
package org.rhwlab.imaging.binarytree;

import java.awt.Stroke;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.*;
import org.rhwlab.imaging.binarytree.LabeledRectangle;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author gevirl
 */
public class SingleNodeImage implements NodeImage{
    public void  drawHorizontal(BinaryTreeNode node,Rectangle2D.Float r,float yMid,Graphics2D g2){
        Stroke save = g2.getStroke();
        Stroke stroke = new BasicStroke(lineWidth);
        g2.setStroke(stroke);        
        
        // draw the horizontal line 
        int[] exps = node.getValues();
        float deltaX = (r.width)/(exps.length);
        float y = r.y + r.height/2;
        for (int i=0 ; i<exps.length ; ++i){
            float x = r.x + i*deltaX;
            Line2D line = new Line2D.Float(x,y,x+deltaX,y);  // draw the line in the midpoint of the rectangle
            g2.setColor(colorScale.getColor(exps[i]));
            g2.draw(line); 
        }
        // draw the vertical line if not a leaf - using the color last set
        if (node.getLessDaughter()!=null && node.getGreaterDaughter()!=null){
            // draw an up line
            float xR = r.x+r.width;
            Line2D line = new Line2D.Float(xR,(r.y+yMid)/2,xR,(r.y+r.height+yMid)/2);
            g2.draw(line);
        }
        Rectangle2D r2d = new Rectangle2D.Float(r.x,y-1,r.width,lineWidth+2);
        rect = new LabeledRectangle(node.getLabel(),r2d);
        g2.setStroke(save);
    }

    public void setLineWidth(int w){
        lineWidth = w;
    }
    public Rectangle2D getBoundingRectangle(){
        return rect.getRectangle();
    } 
    public int getLineWidth(){
        return lineWidth;
    }
    public void setColorScale(ColorScale scale ){
        this.colorScale = scale;
    }
    public List<LabeledRectangle> getRectangles(){
        List<LabeledRectangle> ret = new ArrayList<LabeledRectangle>();
        ret.add(rect);
        return ret;
    }
    ColorScale colorScale;
    LabeledRectangle rect;    
    int lineWidth = 3;
}

