/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;
import java.awt.Color;

/**
 *
 * @author gevirl
 */
public class SingleColorScale implements ColorScale {
    public SingleColorScale(){
        this(0,15000);
    }
    public SingleColorScale(int min,int max){
        this(min,max,Color.red);
    }
    public SingleColorScale(int min,int max,Color c){
        this.max = max;
        this.min = min;
        this.rgb = c.getRGBColorComponents(null);
        this.range = max-min;
        this.c = c;
    }
    public Color getColor(int v){
        float f = 0.5f + 0.5f*(v-min)/range;
        if (f <0.0) f = 0.0f;
        if (f > 1.0)f = 1.0f;
        Color ret =  new Color(f*rgb[0],f*rgb[1],f*rgb[2]);
        return ret;
    }
    public Color[] getColors(){
        Color[] ret = new Color[1];
        ret[0] = c;
        return ret;
    }
    public int getMin(){
        return this.min;
    }
    public int getMax(){
        return this.max;
    }
    Color c;
    int min;
    int max;
    float[] rgb;
    float range;
}
