/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.Graphics2D;

/**
 *
 * @author gevirl
 */
public class NucleotideScale {
    public NucleotideScale(int scale,int[] nucs){
        this.scale = scale;
        this.values = nucs;
        width = values[values.length-1]/scale + 50;
    }
    public BufferedImage getImage() {
        
        BufferedImage image = new BufferedImage(width,height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        
        g2.setColor(Color.black);
        g2.drawLine(0, 0, 0, height);
        g2.drawString("0", 0, height);
        
        int x = 0;
        int prior = 0;
        for (int i=0 ; i<values.length ; ++i){
            int delX = (values[i]-prior)/scale; 
            g2.drawLine(x, height/2, x+delX, height/2);
            g2.drawLine(x+delX,0,x+delX,height);
            g2.drawString(Integer.toString(values[i]), x+delX, height);
            prior = values[i];
            x = x + delX;
        }
        return image;
    }
    public int getWidth(){
        return width;
    }
    public int getHeight(){
        return height;
    }
    int height = 50;
    int width;
    int scale;
    int[] values;
}
