/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.heatmap;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

/**
 *
 * @author gevirl
 */
public class SaveableFrame extends JFrame {

    public SaveableFrame() {
        super();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem save = new JMenuItem("Save");
        fileMenu.add(save);
        save.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    saveContent();
                } catch (Exception exc) {
                    exc.printStackTrace();
                }

            }
        });
    }

    private void saveContent() throws Exception {
        Container content = this.getContentPane();
        if (content instanceof BufferedImagePanel) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
                File sel = chooser.getSelectedFile();
                ImageIO.write(((BufferedImagePanel) content).getImage(), "png", sel);
            }
        }
    }
}
