/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.graphstructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 *
 * @author gevirl
 */
public class Graph {
    public boolean addEdge(String sourceID,String targetID){
        boolean ret = false;
        Node source = nodes.get(sourceID);
        Node target = nodes.get(targetID);
        if (source!=null && target!=null){
            Edge edge = new Edge(source,target);
            edges.add(edge);

            source.addOutEdge(edge);
            target.addInEdge(edge);
            ret = true;
        }
        return ret;
    }
    public void addNode(Node toadd){
        this.nodes.put(toadd.id, toadd);
    }

    public void removeEdge(Edge edge){
        CompositeNode composite = new CompositeNode(edge.source,edge.target);
        edges.remove(edge);
        nodes.remove(edge.source.id);
        nodes.remove(edge.target.id);
        nodes.put(composite.id,composite);
        
    }
    // remove all edges that can be removed without altering the graph structure
    // combines nodes that are tightly connected
    public void collapse(){
        ArrayList<Edge> removeable = new ArrayList<>();
        for (Edge edge : edges){
            if( (edge.source.getOuts().size()==1) && (edge.target.getIns().size()==1) ){
                removeable.add(edge);
            }
        }
        for (Edge edge : removeable){
            this.removeEdge(edge);
        }
    }
    public List<Node> getNodes(){
        ArrayList<Node> ret = new ArrayList<>();
        ret.addAll(this.nodes.values());
        return ret;
    }

    HashMap<String,Node> nodes = new HashMap<>();
    List<Edge> edges = new ArrayList<>();
}
