/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.graphstructure;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author gevirl
 */
public class CompositeNode extends Node{
    public CompositeNode(Node source,Node target){
        super(String.format("%s:%s",source.id,target.id),new ArrayList<>());
        
        // fix and add the input edges
        for (Edge in : source.getIns()){
            this.addInEdge(in);
            in.setTarget(this);
        }
        //fix and add the output edges
        for (Edge out:target.getOuts()){
            this.addOutEdge(out);
            out.setSource(this);
        }
        // combine the data from source and target
        addData(source);
        addData(target);
      
    }
    private void addData(Node node){
        ArrayList dataList = (ArrayList)this.data;
        if (node.data instanceof List){
            dataList.addAll((List)node.data);

        }else {
            dataList.add(node.data);
        }        
    }
    
}
