/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.genemodel;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
    public class mRNA extends Annotation {
        public mRNA(String[] tokens){
            super(tokens);
        }
        
        public int exonBases(List<Annotation> children){
            int bases = 0;
            for (Annotation child : children){
                if (child instanceof Exon){
                    bases = bases + child.getLength();
                }
            }            
            return bases;
        }

        public List<CDS> getCDS(List<Annotation> children){
            ArrayList<CDS> ret = new ArrayList<>();
            for (Annotation child : children){
                if (child instanceof CDS){
                    ret.add((CDS)child);
                }
            }
            return ret;            
        }

        public int exonCount(List<Annotation> children){
            return this.getExons(children).size();
        }
        public int getTranscriptionStart(){
            return this.start;
        }
        public int getTranscriptionEnd(){
            return this.end;
        } 
        public int getCdsStart(List<Annotation> children){
            List<CDS> cdsList = this.getCDS(children);
            if (cdsList.isEmpty()){
                return this.getTranscriptionStart();
            }
            
            int ret = Integer.MAX_VALUE;
            for (CDS cds : cdsList){
                if (ret > cds.start){
                    ret = cds.start;
                }
            }
            return ret;
        }
        public int getCdsEnd(List<Annotation> children){
            List<CDS> cdsList = this.getCDS(children);
            if (cdsList.isEmpty()){
                return this.getTranscriptionEnd();
            }            
            int ret = Integer.MIN_VALUE;
            for (CDS cds : cdsList){
                if (ret < cds.end){
                    ret = cds.end;
                }
            }
            return ret;
        }         

    @Override
    void addAttributes(String attrStr) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getID() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    }
