/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.genemodel;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class WormBaseModel {
    /*
    // build the gene model from the wormbase gffs
    public WormBaseModel(String gff3,String idAttr,String parentAttr)throws Exception {
        Annotation.id = idAttr;
        Annotation.parent = parentAttr;
        BufferedReader reader = new BufferedReader(new FileReader(gff3));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            Annotation annot = null;
            if (tokens[2].equals("gene")){
                annot = new Gene(tokens);
                geneSet.add((Gene)annot);
            }
            else if (tokens[2].equals("mRNA")){
                annot = new mRNA(tokens);
            }
            else if (tokens[2].equals("exon")){
                annot = new Exon(tokens);
            }
            else if (tokens[2].equals("CDS")){
                annot = new CDS(tokens);
            }  
            else {
                annot = new Annotation(tokens);
            }
            
//            String id = annot.getID();
            String[] id = annot.getAttributeValue(idAttr);
            if (id != null){
                String idType = id[0];
                String idName = id[1];
                TreeMap<String,Annotation> annotMap = byIdMap.get(idType);
                if (annotMap == null){
                    annotMap = new TreeMap<>();
                    byIdMap.put(idType,annotMap);
                }
                annotMap.put(idName,annot);
            }
            
 //           String[] parents = annot.getParent();
 //           for (String parent: parents) {
                String[] parent = annot.getAttributeValue(parentAttr);
                if (parent != null){
                    String parentType = parent[0];
                    String parentName = parent[1];
                    TreeMap<String,List<Annotation>> typeMap = this.byParentMap.get(parentType);
                    if (typeMap == null){
                        typeMap = new TreeMap<>();
                        byParentMap.put(parentType, typeMap);
                    }
                    List<Annotation> list = typeMap.get(parentName);
                    if (list == null){
                        list = new ArrayList<>();
                        typeMap.put(parentName, list);
                    }
                    list.add(annot);
                }
 //           }

            line = reader.readLine();
        }
    }


    // output the gene model format compatible with TIP program
    public void outputTIP(PrintStream stream,String bioType){
        stream.println("name\tchrom\tstrand\ttxStart\ttxEnd\tcdsStart\tcdsEnd\texonCount");
//        Set<mRNA> mRNASet = this.getSorted_mRNA();
//        for (mRNA mRNA:mRNASet){
//            stream.printf("%s\t%s\t%s\t%d\t%d\t%d\t%d\t%d\n",
 //                   mRNA.getName(),mRNA.chromo,mRNA.strand,mRNA.getTranscriptionStart(),mRNA.getTranscriptionEnd(),mRNA.getCdsStart(),mRNA.getCdsEnd(),mRNA.exonCount());
//        }
    }
    public Annotation getTranscript(String id){
        return byIdMap.get("Transcript").get(id);
    }
    public Annotation getPseudogene(String id){
        return byIdMap.get("Pseudogene").get(id);    
    }
    public Annotation getTransposon(String id){
        return byIdMap.get("CDS").get(id);
    }
    public Set<String> getAllTranscripts(){
        return byIdMap.get("Transcript").keySet();
    }
    public Set<String> getAllPseudogenes(){
        return byIdMap.get("Pseudogene").keySet();
    }
    public Set<String> getTransposons(){
        return byParentMap.get("CDS").keySet();
    }
    public Annotation getCanonical(String id){
        Annotation ret = this.getTranscript(id);
        if (ret == null) {
            ret = this.getPseudogene(id);
            if (ret == null){
                ret = this.getTransposon(id);
            }
        }
        return ret;
    }
    public List<Exon> getExons(Annotation annot){
        ArrayList<Exon> ret = new ArrayList<>();
        if (annot instanceof Exon){
            ret.add((Exon)annot);
            return ret;
        }
        String id = annot.getID();
        if (id == null) return ret;  // annotation must have an ID to get its exons
        
        String type = id.split(":")[0];
        String name = id.split(":")[1];
        TreeMap<String,List<Annotation>> typeMap =this.byParentMap.get(type);
        if (typeMap == null){
            return ret;
        }
        
        List<Annotation> list = typeMap.get(name);
        if (list == null){
            return ret;
        }
        for (Annotation child : list){
            if (child instanceof Exon){
                ret.add((Exon)child);
            }
        }
        ret.sort(null);
        return ret;
    }
    public String getExonSequence(Annotation annot,TreeMap<String,String> genome){
        if (annot.getName().equals("AC3.2")){
            int asdfuis=0;
        }
        String genomeSequence = genome.get(annot.getChromosome());  // sequence of the chromosome
        StringBuilder builder = new StringBuilder();

        List<Exon> exons = this.getExons(annot);
        for (Exon exon : exons){
            String seq = genomeSequence.substring(exon.start-1, exon.end);
            builder.append(seq);
        }
        String ret = builder.toString();
        if (annot.getStrand().equals("-")){
//            ret = reverseComplement(ret);
        }
        return ret;            
    }    
    static public String reverseComplement(String seq){
        StringBuilder builder = new StringBuilder();
        char[] chars = seq.toUpperCase().toCharArray();
        for (int i=chars.length-1 ; i>=0 ; --i){
            if (chars[i] == 'G'){
                builder.append('C');
            }
            else if (chars[i] == 'C'){
                builder.append('G');
            }
            else if (chars[i] == 'A'){
                builder.append('T');
            }
            else if (chars[i] == 'T'){
                builder.append('A');
            }            
        }
        return builder.toString();
    }  
    public Annotation getAnnotation(String id){
        for (String key : byIdMap.keySet()){
            TreeMap<String,Annotation> map = byIdMap.get(key);
            Annotation annot= map.get(id);
            if (annot != null) return annot;
        }
        return null;
    }
    String[] transcriptTypes = {"Transcript","CDS","Pseudogene"};
    
    static public void main(String[] args) throws Exception {
 //      WormBaseModel gff3 = new WormBaseModel("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3","ID","Parent");
        WormBaseModel model = new WormBaseModel("/net/waterston/vol9/References/Release6/dmel-all-r6.15.gtf","gene_id","transcript_id");
        Set<String> all = model.getAllTranscripts();
        PrintStream exonsStream = new PrintStream("/net/waterston/vol9/References/WS245/AllWormBase.withTransposonExons.gff3");
//        model.report("exon",exonsStream);;
//        model.outputTIP(new PrintStream(args[2]),args[1]);  // AllWormBase.renamed.gff3  protein_coding  /net/waterston/vol9/ChipSeq/TIP/transcriptModel.tab
       

        int aoshdfu=0;
        
    }
*/
    TreeSet<Gene> geneSet = new TreeSet<>(); // set of all the genes in the gff
    TreeMap<String,TreeMap<String,List<Annotation>>> byParentMap = new TreeMap<>(); // list of annotations by parent id
    TreeMap<String,TreeMap<String,Annotation>>  byIdMap = new TreeMap<>();  // annotations with an id indexed by the id
}
