/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model.exons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.rhwlab.LMS.dataframe.FACSSamples;

/**
 *
 * @author gevirl
 */
// Exon Summary file

public class ExonSummary {
    String[] heads;
    ArrayList<ExonData> data = new ArrayList<>();
    TreeMap<String,List<Integer>> geneIndex = new TreeMap<>();
    
    public ExonSummary(File[] files,String[] sampleIDs)throws Exception {
        this(files[0],false);
        
        heads = new String[files.length+7];
        heads[0] = "ExonID";
        heads[1] = "WBGene";
        heads[2] = "GeneName";
        heads[3] = "Chromosome";
        heads[4] = "Start";
        heads[5] = "End";
        heads[6] = "Length";
        heads[7] = sampleIDs[0];
        ExonSummary[] summaries = new ExonSummary[files.length];
        for (int i=1 ; i<files.length ; ++i){
            summaries[i] = new ExonSummary(files[i],false);
            heads[i+7] = sampleIDs[i];
        }
        
        int n = data.size();
        for (int r=0 ; r<n ; ++r){
            ExonData exonData = data.get(r);
            double[] v  = new double[sampleIDs.length];
            v[0] = exonData.data[0];
            for (int i=1 ; i<sampleIDs.length ; ++i){
                v[i] = summaries[i].data.get(r).data[0];
            }
            exonData.data = v;
        }
        int uihsdfuihsd=0;
    }

    public ExonSummary(File file,boolean hasHeader)throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        
        if (hasHeader){
            heads = reader.readLine().split(",");
        }
        
        String line = reader.readLine();
        String currentGene = "";
        List<Integer> list = null;
        int i= 0;
        while (line != null){
            String[] tokens = line.split(",");
            ExonData exonData = new ExonData(tokens);
            data.add(exonData);
            if (!currentGene.equals(exonData.wbgene)){
                currentGene = exonData.wbgene;
                list = new ArrayList<>();
                geneIndex.put(exonData.wbgene,list);
            } 
            list.add(i);
            ++i;
            line = reader.readLine();
        }
    }
    public void saveTo(File file)throws Exception {
        PrintStream stream = new PrintStream(file);
        
        // print the headers
        stream.print(heads[0]);;
        for (int i=1 ; i<heads.length ; ++i){
            stream.printf(",%s", heads[i]);
        }
        stream.println();
        
        
        // print all the data
        for (ExonData exonData : this.data){
            String[] tokens = exonData.asTokens();
            stream.print(tokens[0]);
            for (int i=1; i<tokens.length ; ++i){
                stream.printf(",%s", tokens[i]);
            }
            stream.println();
        }
        stream.close();
    }
    public double[][] getDataForGene(String wbgene){
        double[][] ret = null;
        List<Integer> records = geneIndex.get(wbgene);
        if (records != null){
            ret = new double[records.size()][];
            for (int i=0 ; i<ret.length ; ++i){
                ExonData exonData = data.get(records.get(i));
                ret[i] = exonData.data;
            }
        }
        return ret;
    }
    public Set<String> getGenes(){
        return geneIndex.keySet();
    }
    public TreeMap JS(){
        TreeMap<Double,String> ret = new TreeMap<>();
        for (String wbGene : getGenes()){
            double[][] x = getDataForGene(wbGene);
            double jp = JensenShannon.compute(x);
            ret.put(jp, wbGene);
        }
        return ret;
    }

    public void averageFACSReps(int dataStart){
        TreeMap<String,List<Integer>> toAvg = new TreeMap<>();
        for (int i=dataStart ; i<heads.length ; ++i){
            String head = heads[i];
            String key = FACSSamples.tissueName(head)+FACSSamples.timeString(head);
            List<Integer> list = toAvg.get(key);
            if (list == null){
                list = new ArrayList<>();
                toAvg.put(key,list);
                }
            list.add(i-dataStart);
            
        }
        // average the data
        for (ExonData exonData : this.data){
            double[] avg = new double[toAvg.size()];
            int c = 0;
            for (String key : toAvg.keySet()){
                double sum = 0;
                for (Integer i : toAvg.get(key)){
                    sum = sum + exonData.data[i];
                }
                avg[c] = sum/toAvg.get(key).size();
                ++c;
            }
            exonData.data = avg;
        }
        
        // replace the heads
        String[] replace = new String[dataStart + toAvg.size()];
        for (int i=0 ; i<dataStart ; ++i){
            replace[i] = heads[i];
        }
        String[] keys = toAvg.keySet().toArray(new String[0]);
        int j=0;
        for (int i=dataStart ; i<replace.length ; ++i){
            replace[i] = keys[j];
            ++j;
        }
        this.heads = replace;
        int jahsdfh=0;
        ++jahsdfh;
    }
    // read a previously built exon summary file (for example, by running ExonSignalSummary) and average the FACS replicates
    static public void main(String[] args)throws Exception {
        ExonSummary summary = new ExonSummary(new File("/net/waterston/vol9/FACSBedGraphs/FACSExonSignalSummary"),true);
        summary.averageFACSReps(8);
        summary.saveTo(new File("/net/waterston/vol9/FACSBedGraphs/FACSExonSignalSummary.repavg"));
//        TreeMap jp = summary.JS();
        
        int isfhs=0;
    }
}
