/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model.exons;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.rhwlab.chipseq.BedGraph;
import org.rhwlab.gene.model.Annotation;
import org.rhwlab.gene.model.AnnotationBoundary;
import org.rhwlab.gene.model.AnnotationStart;
import org.rhwlab.gene.model.Exon;
import org.rhwlab.gene.model.ModelFromGFF;

/**
 *
 * @author gevirl
 */
public class ExonSignalSummary {
    ModelFromGFF model;
    BedGraph bedGraph;
    
    public ExonSignalSummary(BedGraph bed,ModelFromGFF gffModel) {
        this.model = gffModel;
        this.bedGraph = bed;
    }

    public void buldResult(PrintStream stream) {
        List<Annotation> geneAnnots = model.getGenesByBiotype("protein_coding");
        for (Annotation proteinGene  : geneAnnots){
            String seqID = (String)proteinGene.getAttributeValue("sequence_name");
            String locus = seqID;
            Object o = proteinGene.getAttributeValue("locus");
            if (o != null){
                locus = (String)o;
            }
            String geneID = proteinGene.getGeneID();
            String chromo = "chr"+proteinGene.getChromosome();

            List<AnnotationBoundary> bounds = model.getExonBoundaries(geneID);
            AnnotationBoundary[] boundsArray = bounds.toArray(new AnnotationBoundary[0]);
            
            AnnotationBoundary start = boundsArray[0];
            int p = -1;
            for (int i=1 ; i<boundsArray.length ; ++i){
                AnnotationBoundary end = boundsArray[i];
                if (p < 0){
                    if (start.getLocation() < end.getLocation()){
                        double v = bedGraph.getAverage(chromo,start.getLocation() , end.getLocation());
                        int l = end.getLocation() - start.getLocation() ;
                        stream.printf("%s,%s,%s,%d,%d,%d,%.3f\n",geneID,locus,seqID,start.getLocation(),end.getLocation(),l,v);
                    }
                }
                if (end instanceof AnnotationStart) {
                    --p;
                } else {
                    ++p;
                }
                start = end;
            }
        }
    }
    
    public float[] buildResult(int n){
        float[] ret = new float[n];
        int j = 0;
        List<Annotation> geneAnnots = model.getGenesByBiotype("protein_coding");
        for (Annotation proteinGene  : geneAnnots){
            
            String geneID = proteinGene.getGeneID();
            String chromo = "chr"+proteinGene.getChromosome();

            List<AnnotationBoundary> bounds = model.getExonBoundaries(geneID);
            AnnotationBoundary[] boundsArray = bounds.toArray(new AnnotationBoundary[0]);
            
            AnnotationBoundary start = boundsArray[0];
            int p = -1;
            for (int i=1 ; i<boundsArray.length ; ++i){
                AnnotationBoundary end = boundsArray[i];
                if (p < 0){
                    if (start.getLocation() < end.getLocation()){
                        double v = bedGraph.getAverage(chromo,start.getLocation() , end.getLocation());
                        ret[j] = (float)v;
                        ++j;
                    }
                }
                if (end instanceof AnnotationStart) {
                    --p;
                } else {
                    ++p;
                }
                start = end;
            }
        }        
        
        return ret;
    }

    
    // from a directory of input bedGraph files, form an exon summary file
    static public void main(String[] args) throws Exception {
        List<float[]> list = new ArrayList<>();
        List<String> samples = new ArrayList<>();
        
        ModelFromGFF gff3 = new ModelFromGFF(new File("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3"));
        List<ExonID> exonIDs = NonOverlapping.buildExonIds(gff3);
        
        String[] allFiles = new File(args[0]).list();
        Arrays.sort(allFiles);
        for (String fileName : allFiles){
            File file = new File(args[0],fileName);
            if (file.getName().endsWith("bedGraph")){
                System.out.println(file.getName());
                samples.add(file.getName().replace(".bedGraph", ""));
//                File resultFile = new File(file.getPath().replace("bedGraph", "summary"));
//                PrintStream stream = new PrintStream(resultFile);  
                
                BedGraph bed = new BedGraph(file.getPath());
                ExonSignalSummary summary = new ExonSignalSummary(bed,gff3);
                list.add(summary.buildResult(exonIDs.size()));
                
//                summary.buldResult(stream);
//                stream.close();
            }
        }
        
        // report results
        PrintStream stream = new PrintStream(new File(args[0],"FACSExonSignalSummary"));
        
        stream.print("Exon,WBGene,Common,Sequence,Chr,Start,End,Length");
        for (String s : samples){
            stream.printf(",%s", s);
        }
        stream.println();
        
        int i=0;
        for (ExonID exonID : exonIDs){
            String geneID = exonID.geneAnnot.getGeneID();
            String seqID = (String)exonID.geneAnnot.getAttributeValue("sequence_name");
            String locus = seqID;
            Object obj = exonID.geneAnnot.getAttributeValue("locus");
            if (obj != null){
                locus = (String)obj;
            }
            String chr = exonID.geneAnnot.getChromosome();
            stream.printf("%s,%s,%s,%s,%s,%d,%d,%d",exonID.id,geneID,locus,seqID,chr,exonID.start,exonID.end,exonID.end-exonID.start);
            for (float[] vs : list){
                stream.printf(",%.3f", vs[i]);
            }
            stream.println();
            ++i;
        }
        stream.close();
    }
}
