/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class ModelFromGTF extends AnnotationModel {
    
    public ModelFromGTF(File gtf)throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(gtf));
        String line = reader.readLine();
        while (line != null){
            if (line.charAt(0)!='#'){
                String[] tokens = line.split("\t");
                Annotation annot = new AnnotationGTF(tokens);
                String gene = (String)annot.getAttributeValue("gene_id");
                String transcript = (String)annot.getAttributeValue("transcript_id");
                this.addAnnotation(annot, gene, transcript);
            }
            line = reader.readLine();
        }
        reader.close();
    }
    static public void main(String[] args)throws Exception {
        Annotation.remapChromo = false;
        ModelFromGTF gtf = new ModelFromGTF(new File("/net/waterston/vol9/References/cb4/Caenorhabditis_briggsae.CB4.40.gtf"));
        
        TreeSet<String> types = new TreeSet<>();
        types.add("protein_coding");
        gtf.toBedFile(types,new File("/net/waterston/vol9/References/cb4/Caenorhabditis_briggsae.CB4.40.bed"));
        
    }
}
