/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;

/**
 *
 * @author gevirl
 */
public class Exon extends AnnotationGFF {
    String id;
    public int count;
    public Exon(){
        count = 0;
    }
    public Exon(String[] tokens){
        super(tokens);
        count = 0;
    }
    public void setID(String id){
        this.id = id;
    }
    public String getId(){
        return this.id;
    }
    static public void sortExons(List<Exon> exons){
        exons.sort(new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                Annotation a1 = (Annotation)o1;
                Annotation a2 = (Annotation)o2;
                int ret = Integer.compare(a1.getStart(),a2.getStart());
                if (ret == 0){
                    ret = Integer.compare(a1.getLength(), a2.getLength());
                }
                return ret;
            }
            
        });        
    }
    
    static public int sameExons(List annots){
        
        Annotation current = (Annotation)annots.get(0);
        for (int i=1 ; i<annots.size() ; ++i){
            Annotation next = (Annotation)annots.get(i);
            if (current.start == next.start && current.end == next.end){
                return i-1;
            }
            current = next;
        }
        return -1;
    }
/*    
    // sort the annotations and find the first overlapping exon
    static public int overlapping(List annots){
        // sort annotations by location and size
        Exon.sortExons(annots);
        
        Annotation current = (Annotation)annots.get(0);
        for (int i=1 ; i<annots.size() ; ++i){
            Annotation next = (Annotation)annots.get(i);
            if (current.overlaps(next)){
                return i-1;
            }
            current = next;
        }
        return -1;
    }
*/
    public Exon clone(){
        Exon a = new Exon();
        a.gene_id = this.gene_id;
        a.transcript_id = this.transcript_id;
        a.chromo = this.chromo;
        a.source = this.source;
        a.type = this.type;
        a.phase = this.phase;
        a.start = this.start;
        a.end = this.end;
        a.attributes = this.attributes;
        a.id = this.id;
        return a;
    }    


}
