/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author gevirl
 */
public class Bed12 {
    String chrom;
    int chromStart;
    int chromEnd;
    String name;
    int score;
    String strand;
    int thickStart;
    int thickEnd;
    int[] itemRGB = new int[3];
    int blockCount=0;
    List<Integer> blockSizes = new ArrayList<>();
    List<Integer> blockStarts = new ArrayList<>();
    
    // construct a bedrecord 
    public Bed12(String chrom,int start,int end,String name,int score,String strand){
        this.chrom = chrom;
        this.chromStart = start;
        this.chromEnd = end;
        this.name = name;
        this.score = score;
        this.strand = strand;
        this.thickStart = start;
        this.thickEnd = end;
    }
    public void setThickStart(int start){
        if (this.strand.equals("+")){
            this.thickStart = start;
        } else {
            this.thickEnd = start;
        }
    }
    public void setThickEnd(int end){
        if (this.strand.equals("+")){
            this.thickEnd = end;
        } else {
            this.thickStart = end;
        }
    } 
    public void setRGB(int[] rgb){
        this.itemRGB[0] = rgb[0];
        this.itemRGB[1] = rgb[1];
        this.itemRGB[2] = rgb[2];
    }
    public void addBlock(int size,int start){
        ++blockCount;
        if (this.strand.equals("+")){
        
            this.blockSizes.add(size);
            this.blockStarts.add(start);
        }
        else {
            this.blockSizes.add(0,size);
            this.blockStarts.add(0,start);
            
        }
    }
    
    public String toString(){
        
        return String.format("%s\t%d\t%d\t%s\t%d\t%s\t%d\t%d\t%d,%d,%d\t%d\t%s\t%s",
                this.chrom,this.chromStart,this.chromEnd,this.name,this.score,this.strand,this.thickStart,this.thickEnd,
                this.itemRGB[0],this.itemRGB[1],this.itemRGB[2],this.blockCount,commaSep(this.blockSizes),commaSep(this.blockStarts));
    }
    private String commaSep(List<Integer> list){
        StringBuilder builder = new StringBuilder();
        if (!list.isEmpty()) {
            builder.append(list.get(0));
        }
        for (int i=1 ; i<list.size() ; ++i){
            builder.append(",");
            builder.append(list.get(i));
        }
        return builder.toString();
    }
}
