/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import java.awt.image.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.expression.ExpressionOnset;
import org.rhwlab.expression.OnsetExpTimeSeries;

/**
 *
 * @author gevirl
 */
// this image gets the onset from the time series associated with it
public class OnsetTimeSeriesImage extends LabeledTimeSeriesImage implements ChangeListener {
    
    public void setTimeseries(OnsetExpTimeSeries ts){
        super.setTimeseries(ts);
        this.setAnnotation("Onset",ts.getOnset());
        ts.addListener(this);  // this image will be notified of changes to the onset
    }
    
    public OnsetExpTimeSeries getTimeseries(){
        return (OnsetExpTimeSeries)super.getTimeseries();
    }
    
    public void stateChanged(ChangeEvent event){
        ExpressionOnset onset = this.getTimeseries().getOnset();
        this.setAnnotation("Onset", onset);
    }
}
