/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import org.rhwlab.imaging.binarytree.AnnotationImage;
import java.awt.*;
import java.awt.geom.*;

/**
 *
 * @author gevirl
 */
public class OnsetScaleImage implements AnnotationImage {
    public void drawAnnotation(Graphics2D g2){
        Stroke save = g2.getStroke();
        BasicStroke wide = new BasicStroke(3);
        String scaleStr = "Onset Rate Scale";

        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(scaleStr, g2);
        
        g2.setColor(Color.BLACK);
        int h = (int)bounds.getHeight();
        float w = (float)bounds.getWidth();
        g2.drawString(scaleStr,0,h);
        for (int i=0 ; i<colors.length ; ++i){
            g2.setColor(Color.BLACK);
            String s = Integer.toString((int)delta*i);
            bounds = g2.getFontMetrics().getStringBounds(s, g2);
            h = h + (int)bounds.getHeight();
            g2.drawString(s,0,h);

            g2.setColor(colors[i]);
            g2.setStroke(wide);
            g2.draw(new Line2D.Float((float)bounds.getWidth(),(float)h,w,(float)h));
            g2.setStroke(save);
        }        
    }
    public void setDimension(Dimension d){
        this.dim = d;
    }
    public void setPosition (int x,int y){
        this.x0 = x;
        this.y0 = y;
    }
    int x0;
    int y0;
    Dimension dim = new Dimension(100,100);
    
    static Color[] colors = {Color.BLUE,Color.GREEN,Color.YELLOW,Color.CYAN,Color.MAGENTA,Color.ORANGE,Color.RED};
    static double delta = 500.0;    
}
