/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

/**
 *
 * @author gevirl
 */
public class LabeledTimeSeriesImage extends TimeSeriesImage {
    public BufferedImage getFullImage(){
        getTimeSeriesImage();
        
        BufferedImage labelImage = new BufferedImage(dim.width,labelHeight,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = labelImage.createGraphics();
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, dim.width, dim.height);
        g2.setColor(Color.black);
        int n = super.timeSeries.size();
        for (int i=0; i<=n ; i=i+inc){
            float x = i*super.dx;
            float y = labelHeight-3;
            g2.drawString(Integer.toString(i), x, y);
        }
        BufferedImage fullImage = new BufferedImage(dim.width,dim.height+labelHeight,BufferedImage.TYPE_INT_ARGB);
        Graphics2D fullg2 = fullImage.createGraphics();
        fullg2.drawImage(expImage, new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR), 0, 0);
        fullg2.drawImage(labelImage, new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR), 0, dim.height);
        return fullImage;    
    }
    public BufferedImage getImage(){
        return getFullImage();
    }
    public BufferedImage getTimeSeriesImage(){
        expImage = super.getImage();
        return expImage;
    }
    public void setDimension(Dimension d){
        super.setDimension(new Dimension(d.width,d.height-labelHeight));
    }    
    BufferedImage expImage=null;
    int labelHeight = 20;
    int inc = 20;
}
