/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import java.awt.Dimension;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.imaging.binarytree.DefaultColorScale;
/**
 *
 * @author gevirl
 */
// constructs a tree image for a given root 
// draws cell lines with expression coloring
// adds a scale to left of image
public class ExpressionTreeImage extends TreeImage {
    public ExpressionTreeImage(){
         cellLineImage = new ExpressionLineImage();

    }
    public void setDimension(Dimension d){
        super.setDimension(d);
        scaleImage.setDimension(new Dimension(20,Math.min(500,d.height)));
    }
    public void setScale(int min,int max){
        cellLineImage.setRange(min, max);
    }
    @Override
    public void setRoot(EmbryoCell root){
        super.setRoot(root);
         scaleImage = new ExpressionScaleImage();
         scaleImage.setLineImage((ExpressionLineImage)cellLineImage);
         scaleImage.setPosition(10,10);
         DefaultColorScale colorScale = new DefaultColorScale(0,(int)(0.5*root.getEmbryo().maxExpression()));
         scaleImage.setColorScale(colorScale);
         ((ExpressionLineImage)cellLineImage).setColorScale(colorScale);
         this.addAnnotation(scaleImage);        
        
    }
    ExpressionScaleImage scaleImage;
}
