/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import org.rhwlab.imaging.binarytree.AnnotationImage;
import java.awt.*;
import java.awt.geom.*;
import org.rhwlab.imaging.binarytree.ColorScale;
/**
 *
 * @author gevirl
 */
public class ExpressionScaleImage implements AnnotationImage {
    // draw the annotation in the given rectangle
    public void drawAnnotation(Graphics2D g2){

        int delta = (max-min)/(divisions);
        Stroke save = g2.getStroke();
        Stroke stroke = new BasicStroke(lineWidth);
        g2.setStroke(stroke);
        
        float y = y0;
        float deltaY = dim.height/divisions;
        int colorInc = colors.length/divisions;
        int index = colors.length-1;
        g2.setColor(Color.black);
        g2.drawString(Integer.toString(max)+"+",x0+lineWidth+5, y);        
        for (int i=0 ; i<divisions ; ++i){
            Line2D line = new Line2D.Float(x0,y,x0,y+deltaY);
            g2.setColor(colors[index]);
            g2.draw(line);
            
            g2.setColor(Color.black);
            g2.drawString(Integer.toString(max-(i+1)*delta),x0+lineWidth+5, y+deltaY);
            index = index - colorInc;
            if (index < 0) index = 0;
            y = y + deltaY;
        }
        g2.setStroke(save);
    }
    public void setLineImage(ExpressionLineImage image){
        Color[] colors = image.getColors();  // gets the colors used in drawing the horizontal expression lines
        int min = image.getMinExp();
        int max = image.getMaxExp();        
    }
    public void setDimension(Dimension d){
        this.dim = d;
    }
    public void setPosition (int x,int y){
        this.x0 = x;
        this.y0 = y;
    }
    public void setColors(Color[] colors){
        this.colors = colors;
    }
    public void setMin(int min){
        this.min = min;
    }
    public void setMax(int max){
        this.max = max;
    }
    public void setColorScale(ColorScale scale){
        this.colors = scale.getColors();
        this.max = scale.getMax();
        this.min = scale.getMin();
    }
    Color[] colors;
    int min;
    int max;
    int x0;
    int y0;
    Dimension dim;
    int divisions = 10;
    int lineWidth = 10;
}
