/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;

import org.rhwlab.imaging.binarytree.Gradient;
import org.rhwlab.beans.EmbryoCell;
import java.awt.*;
import java.awt.geom.*;
import org.rhwlab.imaging.binarytree.ColorScale;

/**
 *
 * @author gevirl
 */
public class ExpressionLineImage implements CellLineImage {
    public ExpressionLineImage(){
        int sahfdi=0;
    }
    public Color drawHorizontal(EmbryoCell cell,float x0,float x1,float y,Graphics2D g2){
        Color color = Color.BLACK;
        Stroke save = g2.getStroke();
        Stroke stroke = new BasicStroke(lineWidth);
        g2.setStroke(stroke);        
        float deltaX = (x1-x0)/(1+cell.getEndTime()-cell.getStartTime());
        int[] exps = cell.getExpression(expType);
        for (int i=0 ; i<exps.length ; ++i){
            float x = x0 + i*deltaX;
            Line2D line = new Line2D.Float(x,y,x+deltaX,y);
            int index= 0;
            if (exps[i] > maxExp){
                index = colors.length-1;
            } else if (exps[i] > minExp) {
                index = ((colors.length-1)*(exps[i]-minExp))/range; 
            }
            color = colors[index];
            g2.setColor(color);
            g2.draw(line); 
            rect = new Rectangle2D.Float(x0,y-1,x1-x0,lineWidth+2);
        }
        g2.setStroke(save);
        return color;
    }
    public void setRange(int min,int max){
        minExp = min;
        maxExp = max;
        range = maxExp - minExp;
    }
    public int getMinExp(){
        return this.minExp;
    }
    public int getMaxExp(){
        return this.maxExp;
    }
    public Color[] getColors(){
        return this.colors;
    }
    public void setLineWidth(int w){
        lineWidth = w;
    }
    public void setExpressionType(String s){
        expType = s;
    }
    public Rectangle2D getBoundingRectangle(){
        return rect;
    }
    public void setColorScale(ColorScale colorScale){
        this.setRange(colorScale.getMin(),colorScale.getMax() );

        colors = colorScale.getColors();
    }
    Color[] colors = Gradient.GRADIENT_RAINBOW;
    String expType = "zblot";
    int lineWidth = 3;
    int minExp=0;
    int maxExp=25000;
    int range = 25000;
    Rectangle2D rect;
}
