/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import java.awt.image.BufferedImage;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.util.*;
/**
 *
 * @author gevirl
 */
// class for drawing the entire tree (all roots) 
public class CompositeTreeImage {
    public CompositeTreeImage(Class cl){
        this.treeImageClass = cl;
    }
    public BufferedImage getImage() {
        buildImage();
        BufferedImage bigimage = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = bigimage.createGraphics(); 
        
        int pos = 0;
        tops = new int[roots.length];  // the pixel y position at the top of each image
        for (int i=0 ; i<roots.length ; ++i){
            TreeImage image = images[i];
            g2.drawImage(image.getImage(),new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,pos);   
            tops[i] = pos + image.image.getHeight();
            pos = pos + image.image.getHeight();
        }
        return bigimage;
    }
    public void buildImage() {
        leafCounts = new int[roots.length];
        int total = 0;
        for (int i =0 ; i<roots.length ; ++i){
            leafCounts[i] = roots[i].getLeafCount();
            total = total + leafCounts[i];
        }
        TreeImage expTree = null;
        tops = new int[roots.length];  // the pixel y position at the top of each image
        images = new TreeImage[roots.length];
        for (int i=0 ; i<roots.length ; ++i){
            int height = (int)(dim.height*((float)leafCounts[i])/(float)total);
            try {
                expTree = (TreeImage)treeImageClass.getConstructor().newInstance();
            } catch (Exception exc){
                exc.printStackTrace();
                System.exit(1);
            }
            expTree.setRoot(roots[i]);
            expTree.setDimension(new Dimension(dim.width,height));
 //           expTree.setScale(min, max);
            images[i] = expTree;
        }
    }    
    public String getLeafAt(int x,int y){
        int bottom = 0;
        for (int i=0 ; i<roots.length ; ++i){
            if (y <= tops[i]){
                return images[i].getLeafAt(x, y-bottom);
            }
            bottom = tops[i]+1;
        }
        return null;
    }
    public String getCellAt(int x,int y){
        int bottom = 0;
        for (int i=0 ; i<roots.length ; ++i){
            if (y <= tops[i]){
                return images[i].getCellAt(x, y-bottom);
            }
            bottom = tops[i]+1;
        }
        return null;
    }  
    public String getClosestCellTo(int x,int y){
        int bottom = 0;
        for (int i=0 ; i<roots.length ; ++i){
            if (y <= tops[i]){
                return images[i].getClosestCellTo(x, y-bottom);
            }
            bottom = tops[i]+1;
        }
        return null;
    }    
    public int getTimeAt(int x){
        return images[0].getTimeAt(x);
    }
    public void setDimension(Dimension d){
        dim = d;
    }
    public void setRoots(EmbryoCell[] rs){
        // sort the roots
        TreeSet<EmbryoCell> set = new TreeSet<EmbryoCell>(new Comparator<EmbryoCell>(){
            public int compare(EmbryoCell c1,EmbryoCell c2){
                return -c1.compareTo(c2);
            }
        });
        for (EmbryoCell root : rs){
            set.add(root);
        }
        roots = set.toArray(new EmbryoCell[0]);
    } 
    public void useSeries(SeriesEmbryo embryo){
        setRoots(embryo.getRoots());
        int leaves = 0;
        for (EmbryoCell r : roots){
            leaves = leaves + r.getLeaves().length;
        }
        setDimension(new Dimension(500,leaves*18));
    }
    public String getFirstLeaf(){
        return images[0].getFirstLeaf();
    }
    public void setScale(int min,int max){
        this.min = min;
        this.max = max;

    }
    Class treeImageClass;
    int min;
    int max;
    Dimension dim;
    EmbryoCell[] roots;
    TreeImage[] images;
    int[] tops;
    int[] leafCounts;
}
