/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression;

import java.util.Random;
/**
 *
 * @author gevirl
 */
public class SimpleTimeSeries implements TimeSeries{
    // time series from a given array
    public SimpleTimeSeries(int[] times,String label){
        values = times;
        this.label = label;
        findMinMax();
    }
    private void findMinMax(){
        min = Integer.MAX_VALUE;
        max = Integer.MIN_VALUE;        
        for (int i=0 ; i< values.length ; ++i){
            if (values[i]>max) max = values[i];
            if (values[i]<min) min = values[i];            
        }
    }
    public int getMin(){
        return min;
    }
    public int getMax(){
        return max;
    }
    public int getRange(){
        return max-min;
    }
    public int get(int i){
        return values[i];
    }
    public int size() {
        return values.length;
    }
    public String getLabel(){
        return label;
    }
    public int[] getValues(){
        return values;
    }
    
    int[] values;
    int min;
    int max;
    String label;
}