/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.demux;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class MultiVariableFormat {
    // read the data file
    static public TreeMap<String,double[]> readFile(File infile,Integer skip) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        
        String line = reader.readLine();  // read the variable names
        String[] names = line.split(",");
        
        // skip the designated number of lines
        line = reader.readLine();
        if (skip != null){
            int i = 1;
            while (i < skip){
                line = reader.readLine();
                ++i;
            }
        }
        
        // build each column
        ArrayList<Double>[] columns;
        columns = new ArrayList[names.length];
        for (int i=0 ; i<columns.length ; ++i){
            columns[i] = new ArrayList<Double>();
        }
        while (line != null){
            String[] tokens = line.split(",");
            for (int i=0 ; i<tokens.length ; ++i){
                ArrayList<Double> col = columns[i];
                col.add(new Double(tokens[i]));
            }
            line = reader.readLine();
        }
        reader.close();
        
        TreeMap<String,double[]> ret = new TreeMap<String,double[]>();
        for (int i=0 ; i<names.length ; ++i){
            ArrayList list = columns[i];
            double[] data = new double[list.size()];
            for (int j=0 ; j<data.length ; ++j){
                data[j] = (Double)list.get(j);
            }
            ret.put(names[i],data);
        }

        return ret;
    }    
}
