/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import java.util.regex.*;
import org.rhwlab.formats.GFF;
import org.rhwlab.db.MySql;
import java.util.*;
import java.io.*;
/**
 *
 * @author gevirl
 */
public class TSS {
    public TSS(){
        
    }

    static void loadFromGFF(MySql db,GFF gff)throws Exception {
        HashMap<String,TSS> map = gff.readAsTSS();
        for (TSS tss:map.values()){
            String sql = String.format("Insert into TSS (Gene,Chromosome,Base) values (\'%s\',\'%s\',%d)", tss.gene,tss.chromosome,tss.base);
            db.execute(sql);
        }
    }
    // construct this TSS object from a GFF file line
    public void fromGFF(String line){
        String[] tokens = line.split("\t");
        chromosome = tokens[0];
        base = Integer.valueOf(tokens[3]);
        strand = tokens[6];
        String[] names = tokens[8].split(":");
        String name = names[names.length-1];
        Matcher matcher = genePattern.matcher(name);
        if (matcher.lookingAt()){
            this.gene = matcher.group(1);
        }
        matcher = idPattern.matcher(tokens[8]);
        if (matcher.lookingAt()){
            this.id = matcher.group(1);
        }
    }
    public String getID(){
        return id;
    }
    public String getGene(){
        return gene;
    }
    public int getBase(){
        return base;
    }
    public String getChromosome(){
        return this.chromosome;
    }
    static public void main(String[] args){
        try {
            MySql db = MySql.getMySql();
            GFF gff = new GFF(new File(args[0]));
            TSS.loadFromGFF(db, gff);
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }    
    String id;
    String gene;
    String chromosome;
    int base;
    String strand;
    static Pattern genePattern = Pattern.compile(".+_.+_(.+)\\.");
    static Pattern idPattern = Pattern.compile("ID=(.+);prediction");
}
