/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import jxl.*;
import org.rhwlab.db.MySql;
import java.sql.*;
/**
 *
 * @author gevirl
 */
public class Fosmid {
    // load fosmid data from a spread sheet row
    public void fromSheetRow(Sheet sheet,int row){
        Cell[] heads = sheet.getRow(0);
        Cell[] rowCells = sheet.getRow(row);
        String plate = null;
        String location = null;
        for (int i=0 ; i<heads.length ; ++i){
            String head = heads[i].getContents();
            if (head.equals("TransgeneID")){
                this.name = rowCells[i].getContents();
            } else if (head.equals("FID (Fosmid ID)")){
                this.id = rowCells[i].getContents();
            } else if (head.equals("gene")) {
                this.gene = rowCells[i].getContents();
            } else if (head.equals("Transcript")){
                this.transcript = rowCells[i].getContents();
            } else if (head.equals("tag")){
                this.tag = rowCells[i].getContents();
            } else if (head.equals("Plate")) {
                plate = rowCells[i].getContents();
            } else if (head.equals("location")){
                location = rowCells[i].getContents();
            }

        }
            if (this.name == null){
                this.name = plate+location;
            } else if (this.name.equals("")){
                this.name = plate+location;
            }        
    }
    public void toMySql(MySql db) throws Exception {
        // is there a fosmid record in the db?
        String sql = String.format("Select * from Fosmids where FosmidName=\'%s\'", this.name);
        ResultSet  rs = db.execute(sql);
        if (!rs.next()){
            // add a new record for this fosmid
            sql = String.format("Insert into Fosmids (FosmidName) values (\'%s\')", this.name);  
            db.execute(sql);
        }
        // update the values
        if (this.id != null){
            sql = String.format("Update Fosmids set FosmidId=\'%s\' where FosmidName=\'%s\'",this.id,this.name);
            db.execute(sql);            
        }
        if (this.gene != null){
            sql = String.format("Update Fosmids set Gene=\'%s\' where FosmidName=\'%s\'",this.gene,this.name);
            db.execute(sql);               
        }
        if (this.transcript != null){
            sql = String.format("Update Fosmids set Transcript=\'%s\' where FosmidName=\'%s\'",this.transcript,this.name);
            db.execute(sql);               
        }  
        if (this.tag != null){
            sql = String.format("Update Fosmids set Tag=\'%s\' where FosmidName=\'%s\'",this.tag,this.name);
            db.execute(sql);               
        }         

    }  
    static public Fosmid fromMySql(MySql db,String fosmidName) throws Exception {
        String sql = String.format("Select * from Fosmids where FosmidName=\'%s\'", fosmidName);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            Fosmid fosmid = new Fosmid();
            fosmid.name = fosmidName;
            fosmid.gene = rs.getString("Gene");
            fosmid.id = rs.getString("FosmidId");
            fosmid.tag = rs.getString("Tag");
            fosmid.transcript = rs.getString("Transcript");
            return fosmid;
        }
        return null;
        
    } 
    static public Fosmid fromMySql(String fosmidID) throws Exception {
        String sql = String.format("Select * from Fosmid where FosmidID=\'%s\'", fosmidID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            Fosmid fosmid = new Fosmid();
            fosmid.name = rs.getString("TransgeneID");
            fosmid.gene = rs.getString("Gene");
            fosmid.id = rs.getString("FosmidDescr");
            fosmid.tag = rs.getString("Tag");
            String wbGene = rs.getString("WBGene");
            sql = String.format("Select * from Gene where WBGene=\'%s\'",wbGene);
            ResultSet geneRS = MySql.getMySql().execute(sql);
            if(geneRS.next()){
                fosmid.transcript = geneRS.getString("Sequence");
            }
            return fosmid;
        }
        return null;
        
    }     
    public String getName() {
        return this.name;
    }
    public String getId(){
        return this.id;
    }
    public String getGene(){
        return this.gene;
    }
    public String getTranscript(){
        return this.transcript;
    }
    public String getTag(){
        return this.tag;
    }
    String name;
    String id;
    String gene;
    String transcript;
    String tag;
}
