/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;

import org.rhwlab.db.MySql;
import java.io.*;
import java.util.*;
import java.sql.*;
/**
 *
 * @author gevirl
 */
public class Exon {
    public Exon(String seq,int s, int e){
        this.sequence = seq;
        this.start = s;
        this.end = e;
    }
    public static void loadDB(MySql db,File gff) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(gff));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            String seq = tokens[8].split(":")[1];
            String chr = tokens[0].split("_")[1];
            String start = tokens[3];
            String end = tokens[4];
            String strand = tokens[6];
            
            String sql = String.format("Insert into Exons (Sequence,Start,End) values (\'%s\',%s,%s)",
                    seq,tokens[3],tokens[4]);
            db.execute(sql);
            
            line = reader.readLine();
        }
        
    }
    // get a list of exons for the given gene
    // collects all exons from all transcripts
    // overlapping exons are combined
    public static List<Exon> getExons(MySql db,Gene gene) throws Exception {
        
        ArrayList<Exon> ret = new ArrayList<Exon>();
        String wbGene = gene.getWBGene();
        String sql = String.format("Select E.Start,E.End from Exons E,WBGenes W where W.WBGene=\'%s\' "
                + "and W.Alias=E.Sequence order by E.Start,E.End",wbGene);
        ResultSet rs = db.execute(sql);
        
     
        if (!rs.next()) return ret; // did not find any exons
        Exon last = new Exon(gene.getSequenceName(),rs.getInt("Start"),rs.getInt("End"));
        ret.add(last);
        
        while (rs.next()){
            Exon current = new Exon(gene.getSequenceName(),rs.getInt("Start"),rs.getInt("End"));
            // does this exon overlap with the previous one
            if (last.overlap(current)){
                last.combine(current);
            } else {
                ret.add(current);
                last = current;
            }
        }
        return ret;
    }
    public boolean overlap(Exon other){
        return (this.start <= other.start && other.start <= this.end) || (this.start <= other.end && other.end <= this.end) || (other.start <= this.start && this.end <= other.end);
    }
    public void combine(Exon other){
        this.start = Math.min(this.start, other.start);
        this.end = Math.max(this.end, other.end);
    }
    public int getStart(){
        return start;
    }
    public int getEnd(){
        return end;
    }
    static public void main(String[] args){
        try {
            MySql db = MySql.getMySql();
            Exon.loadDB(db, new File(args[0]));
        }catch(Exception exc){
            exc.printStackTrace();
        }
    }
    int start;
    int end;
    String sequence;
}
