/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.ArrayList;
import java.util.TreeMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

/**
 *
 * @author gevirl
 */
public class ChromosomeRegion implements HasRegion{
        public ChromosomeRegion(String chrom,int s,int e){
            this(chrom,s,e,true);
        }
    public ChromosomeRegion(String chrom,int s,int e,boolean withDNA){
        this.chromosome = chrom;
        this.start = s;
        this.end = e;
        if (withDNA){
            String urlString = String.format("http://genome.cse.ucsc.edu/cgi-bin/das/ce10/dna?segment=%s:%s,%s",
                    chromosome,start,end);
            SAXBuilder saxBuilder = new SAXBuilder();
            Document doc = null;
            try {
                doc = saxBuilder.build(new URL(urlString)); 
            } catch (Exception exc){
                return;
            }
            if (doc == null) {
                return;
            }
            Element root = doc.getRootElement();
            Element sequence = root.getChild("SEQUENCE");
            Element dnaSeq = sequence.getChild("DNA");
            String dnaString = dnaSeq.getTextNormalize();
            dna = dnaString.replace(" ","");    
        }
    }
    // filter a list of regions into a non overlapping list
    public static List nonOverLapping(List<HasRegion> regions){
        ArrayList<HasRegion> ret = new ArrayList<HasRegion>();
        HasRegion current = regions.get(0);
        HasRegion next = regions.get(1);
        if (!current.getRegion().overlaps(next.getRegion())) ret.add(current); // check the first
        
        HasRegion prev = current;
        current = next;
        for (int i=1 ; i<regions.size()-1 ;++i){
            next = regions.get(i+1);
            if (!current.getRegion().overlaps(next.getRegion())
                    && !current.getRegion().overlaps(prev.getRegion())){
                ret.add(current);
            } 
            prev = current;
            current = next;
        }
        if (!current.getRegion().overlaps(prev.getRegion())) ret.add(current);  // check the last
        return ret;
    }
    // combine regions that overlap into a list of CombinedRegions
    static public List<CombinedRegion> groupByOverlap(List<HasRegion> regions){
        List<CombinedRegion> list = new ArrayList<CombinedRegion>();;
        
        int pos = 0;
        while (pos < regions.size()){
            CombinedRegion combined = overlapRegion(regions,pos);
            list.add(combined);
            pos = pos + combined.getCount();
        }       
        return list;
    }
    // determine the combined region from a list of regions 
    // starting at the index position in the list
    static public CombinedRegion overlapRegion(List<HasRegion> regions,int index){
        CombinedRegion combined = new CombinedRegion(regions.get(index));
        
        while (index < regions.size()-1){
            ++index;
            HasRegion next = regions.get(index);
            if (!combined.combine(next)) {
                break;
            }
        }
        return combined;
    }
    // do two regions overlap?
    public boolean overlaps(ChromosomeRegion other){
        if (!this.chromosome.equals(other.chromosome)) return false; // not the same chromosome
        return this.inside(other.start) || this.inside(other.end) || other.inside(this.start) || other.inside(this.end);
    }

    // is a position within the region?
    public boolean inside(int v){
        return (start <= v && v <= end);
    }
    // is this region below the other
    public boolean isBelow(ChromosomeRegion other){
        return this.end < other.start;
    }
    public String getChromosome(){
        return this.chromosome;
    }
    public int getStart(){
        return this.start;
    }
    public int getEnd(){
        return end;
    }
    public void dump(PrintStream stream) {
        stream.printf("%s,%d,%d", chromosome,start,end);
    }
    public ChromosomeRegion getRegion(){
        return this;
    }
    public String getLabel(){
        return this.chromosome;
    }
    public String getDNASequence(){
        return dna;
    }
    String dna;
    String chromosome;
    int start;
    int end;
}
