/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.coordinates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

/**
 *
 * @author gevirl
 */
public class Region {
    // convert genomic coordinates
    // eg source="130"  dest="190"
    static public Region[] convert(String source,String dest,Region[] regions)throws Exception {
        Region[] ret = new Region[regions.length];
        File remapDir = new File(remapDirectory);
        File sourceGFF = File.createTempFile(source,".gff");
        File destGFF = File.createTempFile(dest,".gff");
        
        // write the source GFF
        PrintWriter writer = new PrintWriter(sourceGFF);
        for (int i=0 ; i<regions.length ; ++i){
            Region region = regions[i];
            writer.printf("%s\t.\t.\t%d\t%d\t.\t%s\t.\t%s\n",region.chromosome,region.start,region.end,region.strand,region.annotation);
        }
        writer.flush();
        writer.close();
        
        // do the coversion
        ArrayList<String> cmdLine = new ArrayList<>();
        cmdLine.add("perl");
        cmdLine.add("remap_gff_between_releases.pl");
        cmdLine.add("-gff");
        cmdLine.add(sourceGFF.getPath());
        cmdLine.add("-out");
        cmdLine.add(destGFF.getPath());
        cmdLine.add("-release1");
        cmdLine.add(source);
        cmdLine.add("-release2");
        cmdLine.add(dest);        
        ProcessBuilder processBuilder = new ProcessBuilder(cmdLine);
        processBuilder.directory(remapDir);
        Process process = processBuilder.start();
        process.waitFor();
        
        // read the destination GFF
        BufferedReader reader = new BufferedReader(new FileReader(destGFF));
        String line = reader.readLine();
        int i=0;
        while (line != null){
            String[] tokens = line.split("\t");
            Region region = new Region();
            ret[i] = region;
            region.chromosome = tokens[0];
            region.start = Integer.valueOf(tokens[3]);
            region.end = Integer.valueOf(tokens[4]);
            region.strand = tokens[6];
            region.annotation = tokens[8];
            line = reader.readLine();
            ++i;
        }
        reader.close();
        
        return ret;
    }
    static String remapDirectory = "/nfs/waterston/Remap-for-other-groups";
    public String chromosome;
    public int start;
    public int end;
    public String strand;
    public String annotation;
    
    static public void main(String[] args)throws Exception{
        ArrayList<Region> regionList = new ArrayList<>();
        ArrayList<String> lines = new ArrayList<>();
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String line = reader.readLine();
        while (line != null){
            lines.add(line);
            String[] tokens = line.split(",");
            if (tokens.length==4 && !tokens[2].equals("")){
                Region region = new Region();
                region.chromosome = "CHROMOSOME_"+tokens[2].split(":")[1];
                region.strand = "+";
                String coords = tokens[2].split(":")[2];
                int index = coords.indexOf("..");
                String start = coords.substring(0,index);
                region.start = Integer.valueOf(start);
                String end = coords.substring(index+2);
                region.end = Integer.valueOf(end);
                region.annotation = tokens[3];
                regionList.add(region);
            }
            line = reader.readLine();
        }
        Region[] regions = regionList.toArray(new Region[0]);
        Region[] converted = Region.convert("130","190", regions);
        HashMap<String,Region> convertedMap = new HashMap<>();
        for (Region region : converted){
            convertedMap.put(region.annotation, region);
        }
        
        // write an output file
        PrintWriter writer = new PrintWriter(args[1]);
        for (String inputLine : lines){
            String[] tokens = inputLine.split(",");
            
            if (tokens.length==4 && !tokens[2].equals("")){
                Region region = convertedMap.get(tokens[3]);
                int index = region.chromosome.indexOf("_");
                writer.printf("%s,WS190:%s:%d..%d\n", inputLine,region.chromosome.substring(index+1),region.start,region.end);
            }else {
                writer.println(inputLine);
            }
        }
        writer.flush();
        writer.close();
    }
}
