/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class WigFile {
    public WigFile(){
        if (chromoSizes == null){
            chromoSizes = new TreeMap<>();
            chromoSizes.put("chrI", 15072434);
            chromoSizes.put("chrII", 15279421);
            chromoSizes.put("chrIII", 13783801);
            chromoSizes.put("chrIV", 17493829);
            chromoSizes.put("chrV", 20924180);
            chromoSizes.put("chrX", 17718942);
        }
        for (String chromo : chromoSizes.keySet()){
            records.put(chromo, new ArrayList<Entry>());
        }
    }
    public WigFile(String fileName)throws Exception {
        this();
        this.fileName = fileName;
        init();
    }
    final public void init() throws Exception {
        this.min = Double.MAX_VALUE;
        this.max = -Double.MAX_VALUE;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        track = reader.readLine();
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t| ");
            List<Entry> recList = (List<Entry>)records.get(tokens[0]);
            if (recList != null){
                Entry rec = new Entry();
                rec.start = Integer.valueOf(tokens[1]);
                rec.end = Integer.valueOf(tokens[2]);
                rec.value = Double.valueOf(tokens[3]);
                if (rec.value < min){
                    min = rec.value;
                }
                if (rec.value > max){
                    max = rec.value;
                }
                recList.add(rec);
            }
            line = reader.readLine();
        }
        reader.close();
    }
    // replace the contracted storage format with the expanded format
    public void expand(){
        for (String chrom : this.records.keySet()){
            Double[] expanded = this.expand(chrom);
            records.put(chrom, expanded);
        }
    }
    public Double[] expand(String chromo){
        Double[] ret = new Double[chromoSizes.get(chromo)];
        for (int i=0 ; i<ret.length ; ++i){
            ret[i] = null;
        }
        
        for (Entry rec : (List<Entry>)records.get(chromo)){
            for (int i=rec.start ; i<=rec.end ; ++i){
                ret[i] = rec.value;
            }
        }
        return ret;
    }
    // replace the expanded format with the contracted format
    public void contract(){
        for (String chrom : this.records.keySet()){
            Double[] expanded = (Double[])this.records.get(chrom);
            records.put(chrom, this.contract(chrom, expanded));
        }        
    }
    public List<Entry> contract(String chromo,Double[] values){
        ArrayList<Entry> ret = new ArrayList<>();

        int currentStart = 1;
        int currentEnd = 1;
        Double currentValue = values[1];
        
        for (int i=2 ; i<values.length ; ++i){
            if (currentValue == null && values[i] == null){
                ++currentEnd;
            }
            else if (currentValue != null && currentValue.equals(values[i])){
                ++currentEnd;
            } else {
                // save the current record if not null value
                if (currentValue != null){
                    Entry rec = new Entry();
                    rec.start = currentStart;
                    rec.end = currentEnd;
                    rec.value = currentValue;
                    ret.add(rec);
                }
                // start a new record
                currentStart = currentEnd = i;
                currentValue = values[i];
            }
        }
        this.records.put(chromo, ret);
        return ret;
    }
    public void save(PrintStream stream,boolean header){
        if (header) stream.println(track);
        for (String chromo : this.records.keySet()){
            List<Entry> recList = (List < Entry>)this.records.get(chromo);
            for (Entry rec : recList){
                stream.printf("%s %d %d %f\n",chromo,rec.start,rec.end,rec.value);
            }
        }
        stream.flush();
    }
    // add another wig file onto this one, both must be in expanded format
    public void addTo(WigFile other){
        this.min = Double.MAX_VALUE;
        this.max = -Double.MAX_VALUE;
        for (String chromo : this.records.keySet()){
            Double[] expanded = (Double[])this.records.get(chromo);
            Double[] otherExpanded = (Double[])other.records.get(chromo);
            for (int i=0 ; i<expanded.length ; ++i){
                if (expanded[i] == null && otherExpanded[i] != null){
                    expanded[i] = otherExpanded[i];

                } 
                else if (expanded[i]!=null && otherExpanded[i] != null){
                    expanded[i] = expanded[i] + otherExpanded[i];
                    
                }
                if (expanded[i] != null){
                    if (expanded[i] < this.min){
                        this.min = expanded[i];
                    }
                    if (expanded[i] > this.max){
                        this.max = expanded[i];
                    }  
                }
            }
        }
    }
    // scale the wig file to a min and max
    // must be expanded
    public void scaleTo(double toMin,double toMax){
        double delta = this.max-this.min;
        double toDelta = toMax-toMin;
        for (String chromo : this.records.keySet()){
            Double[] expanded = (Double[])this.records.get(chromo);
            for (int i=0 ; i<expanded.length ; ++i){
                if (expanded[i] != null){
                    double x = (expanded[i] - this.min)/delta;  // values are now between 0.0 and 1.0
                    expanded[i] = toMin + toDelta*x;
                }
            }
        }
        this.min = toMin;
        this.max = toMax;
    }
    // scale the wig file by the values in another
    // both must be expanded
    public void scaleBy(WigFile other ){

        for (String chromo : this.records.keySet()){
            double mu= other.mean(chromo);
            Double[] expanded = (Double[])this.records.get(chromo);
            Double[] otherExpanded = (Double[])other.records.get(chromo);
            for (int i=0 ; i<expanded.length ; ++i){
 
                if (expanded[i]!=null && otherExpanded[i] != null && expanded[i] >0.0){
                    expanded[i] = expanded[i]-(otherExpanded[i]-mu);
                    if (expanded[i] < 0.0){
                        expanded[i] = 0.0;
                    }
                }else {
                    expanded[i] = 0.0;
                }
            }            
        }
    }
    // smooth an expanded wig by averaging over the width given
    public void smooth(int width){
       for (String chrom : this.records.keySet()){
           Double[] data = (Double[])this.records.get(chrom);
           smooth(data,width);
       }
    }
    public void smooth(Double[] data,int width){
        int begin = 0;
        while (begin < data.length){
            int end = Math.min(begin + width - 1,data.length-1);
            double sum = 0.0;
            int count = 0;
            for (int i=begin ; i<=end ; ++i){
                if (data[i] != null){
                    sum = sum + data[i];
                    ++count;
                }
            }
            if (count > 0){
                for (int i=begin ; i<=end ; ++i){
                    if (data[i] != null){
                        data[i] = sum/count;
                    }
                }
            }
            begin = end + 1;
        }
    }
    public double mean(String chromo){
        Double[] data = (Double[])this.records.get(chromo);
        double sum = 0.0;
        int count = 0;
        for (int i=0 ; i<data.length ; ++i){
            if (data[i] != null){
                ++count;
                sum = sum  + data[i];
            }
        }
        return sum/count;
    }
    static void combineFiles(String dir,String extension,PrintStream stream)throws Exception {
        RecursiveFile recur = new RecursiveFile(dir);
        List<File> wigs = recur.findFiles(extension);
        WigFile combined=null;
        int i=0;
        for (File wig : wigs){
            if (wig.getPath().substring(0, wig.getPath().indexOf(extension)).contains("Rep0")){
                ++i;
                if (i == 1){
                    combined = new WigFile(wig.getPath());
                    combined.expand();
                    combined.scaleTo(0.0,1000.0);
                }
                else {
                    WigFile other = new WigFile(wig.getPath());
                    other.expand();
                    other.scaleTo(0.0,1000.0);
                    combined.addTo(other);
                }
                System.out.printf("%d %s %f %f\n",i,wig.getPath(),combined.min,combined.max);
            }
        }
        combined.scaleTo(0.0,1000.0);
        combined.contract();
        combined.save(stream,false);
    }
    public class Entry {
        int start;
        int end;
        double value;
    }
    String fileName;
    String track;
    TreeMap<String,Object> records = new TreeMap<>();
    double min;
    double max;
    static TreeMap<String,Integer> chromoSizes=null;
    
    // test the class
    static public void main(String[] args)throws Exception {
// args = /net/waterston/vol9/ChipSeq/data   Input_Rep0.tagAlign.wig  /net/waterston/vol9/ChipSeq/combined.wig
//        combineFiles(args[0],args[1],new PrintStream(args[2]));
/*        
        // smooth the results of combining all the experiments
        WigFile wig = new WigFile(args[0]);
        wig.expand();
        wig.smooth(100);
        wig.contract();
        PrintStream stream = new PrintStream(args[0]+".smooth");
        wig.save(stream);
*/        
        // scale/normalize a wig file with the overall accumulated wig for input to TIP
        WigFile tfWig = new WigFile(args[0]);
        tfWig.expand();
        tfWig.scaleTo(0.0, 1000.0);
        WigFile stdWig = new WigFile(args[1]);
        stdWig.expand();
        stdWig.scaleTo(0.0, 1000.0);
        
        tfWig.scaleBy(stdWig);
        tfWig.smooth(200);
        tfWig.contract();
        tfWig.save(new PrintStream(args[0]+".norm"),true);
        
    }
}
