/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author gevirl
 */
public class RecursiveFile extends File {
    public RecursiveFile(String fileName){
        super(fileName);
    }
    public List<File> findFiles(String extension){
        ArrayList<File> ret = new ArrayList<>();
        if (this.isDirectory()){
            RecursiveFile.findFiles(this, extension, ret);
        }
        return ret;
    }
    // add the file with given extension to the list (recursive)
    static public void findFiles(File dir,String extension,ArrayList<File> files){
        File[] subFiles = dir.listFiles();
        for (File subFile : subFiles){
            if (subFile.isDirectory()){
                RecursiveFile.findFiles(subFile, extension, files);
            } else {
                if (subFile.getName().endsWith(extension)){
                    files.add(subFile);
                }
            }
        }

    }
    // test the class
    static public void main(String[] args)throws Exception {
        RecursiveFile file = new RecursiveFile(args[0]);
        List<File> files = file.findFiles("bigWig");
        for (File f : files){
            System.out.println(f.getAbsolutePath());
        }
    }
}
