/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class QualityDoc {
    public QualityDoc(String file){
        this.file = file;
    }
    
    public void init()throws Exception{
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();  // skip header
        line = reader.readLine();
        while(line != null){
            String[] tokens = line.split("\t");
            String[] ids = tokens[0].split("_");
            String exper = String.format("%s_%s_%s_%s_%s", ids[0], ids[1], ids[2], ids[3], ids[4]);

            if (Integer.valueOf(tokens[4])<0 ){
                experRejected.add(exper);
                addReps(ids,this.repsRejected);
            } else {
                experAccepted.add(exper);
                addReps(ids,this.repsAccepted);
            }
            line = reader.readLine();
        }
    }
    private void addReps(String[] ids,TreeSet<String> set){
        if (ids[6].contains("a")){
            set.add(String.format("%s_%s_%s_%s_%s_%s_a", ids[0], ids[1], ids[2], ids[3], ids[4],ids[5]));
        }
        if (ids[6].contains("b")){
            set.add(String.format("%s_%s_%s_%s_%s_%s_b", ids[0], ids[1], ids[2], ids[3], ids[4],ids[5]));
        }        
    }
    public boolean passes(String exper){
        return !experRejected.contains(exper);
    }
    public TreeSet<String> getRepsAccepted(){
        return this.repsAccepted;
    }
    public TreeSet<String> getExperAccepted(){
        return this.experAccepted;
    }
    public TreeSet<String> getExperRejected(){
        return this.experRejected;
    }
    TreeSet<String> experRejected =new TreeSet<>();
    TreeSet<String> experAccepted = new TreeSet<>();
    TreeSet<String> repsAccepted = new TreeSet<>();
    TreeSet<String> repsRejected =new TreeSet<>();
    String file;
}
