/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;


/**
 *
 * @author gevirl
 */
public class Peak implements Comparable {

    public Peak(String t,int start, short len, short apex) {
        this.start = start;
        this.len = len;
        this.apex = start + apex;
        this.tf = t;
        
    }
    public Peak(ChipSeqBedRecord bedRec){
        this.start = bedRec.getStart();
        this.len = (short)(bedRec.getEnd()-bedRec.getStart());
        this.apex = bedRec.getPeakOffset() + bedRec.getStart();
        this.tf = bedRec.getTF();
        this.bedRecord = bedRec;
    }
    int start;
    short len;
    int apex;
    String tf;
    ChipSeqBedRecord bedRecord;

    @Override
    public int compareTo(Object o) {
        Peak other = (Peak) o;
        return Integer.compare(this.apex, other.apex);
    }
    
    public int distanceTo(Peak other){
        return other.apex - this.apex;
    }
    public ChipSeqBedRecord getBedRecord(){
        return bedRecord;
    }
}
