/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalTree;
import htsjdk.samtools.util.IntervalTreeMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.chipseq.ChipSeqBedRecord;
import org.rhwlab.gene.model.Annotation;
import org.rhwlab.singlecell.randomforest.ImportanceScore;

/**
 *
 * @author gevirl
 */
public class ImportanceAnnotatedBedRecord extends ChipSeqBedRecord {

    String byImportanceTarget = "";
    String classification = "";

    public ImportanceAnnotatedBedRecord(String record) {
        super(record);
        String[] tokens = record.split("\t");
        if (tokens.length > 13) {
            this.classification = tokens[13];
            this.byImportanceTarget = tokens[14];
        }
    }

    public ImportanceAnnotatedBedRecord(String record, String expFile, IntervalTreeMap geneTreeMap, TreeMap<String, IntervalTree> geneTrees) throws Exception {
        super(record);
        findImportanceTarget(expFile, geneTreeMap, geneTrees);
        int jsdfhsd = 0;
    }

    public void findImportanceTarget(String expFile, IntervalTreeMap geneTreeMap, TreeMap<String, IntervalTree> geneTrees) throws Exception {
        if (geneTrees == null || geneTreeMap == null) {
            return;
        }
        TreeMap<Annotation, String> candidates = new TreeMap<>();

        // is this ChipSeq peak intragenic?
        Set<String> intra = new TreeSet<>();
        int peakLoc = this.getPeakLocation();
        Interval peakInterval = new Interval(this.getChromosome(), peakLoc, peakLoc);
        Collection overlappingGene = geneTreeMap.getOverlapping(peakInterval);
        if (!overlappingGene.isEmpty()) {
            Iterator iterator = overlappingGene.iterator();
            while (iterator.hasNext()) {
                Annotation geneAnnot = (Annotation) iterator.next();
                candidates.put(geneAnnot, "Intra");  // add all the genes for which it is intragenic to the candidates
                intra.add(geneAnnot.getGeneName());
            }
        }

        // find upstream gene
        IntervalTree geneTree = geneTrees.get(this.getChromosome());
        IntervalTree.Node upnode = geneTree.min(peakLoc + 1, peakLoc + 1);
        if (upnode != null) {
            Annotation upAnnot = (Annotation) upnode.getValue();
            candidates.put(upAnnot, "Up");
        }
        // find the downstream gene 
        Iterator iter = geneTree.reverseIterator(peakLoc, peakLoc);
        while (iter.hasNext()) {
            IntervalTree.Node downnode = (IntervalTree.Node) iter.next();
            Annotation downAnnot = (Annotation) downnode.getValue();
            if (downAnnot.getEnd() < peakLoc) {
                candidates.put(downAnnot, "down");
                break;
            }
        }
        // find the target with most importance
        Annotation bestCandidate = null;
        Double importance = Double.MIN_VALUE;
        for (Annotation candidate : candidates.keySet()) {
            Double d = ImportanceScore.getImportance(candidate.getGeneName(), this.getTF(), expFile);
            if (d != null && d > importance) {
                importance = d;
                bestCandidate = candidate;
            }
        }
        if (bestCandidate != null) {
            this.byImportanceTarget = bestCandidate.getGeneName();

            // determine the classification
            if (!intra.isEmpty()) {
                this.classification = "G"; // peak is intrageneic
            } else {
                this.classification = "I";// peak is intergeneic
            }

            String direction = candidates.get(bestCandidate);
            if (direction.equals("Intra")) {
                this.classification = this.classification + "G";
            } else if (direction.equals("Up")) {
                if (bestCandidate.getStrand().equals("+")) {
                    this.classification = this.classification + "5";
                } else {
                    this.classification = this.classification + "3";
                }
            } else if (bestCandidate.getStrand().equals("+")) {
                this.classification = this.classification + "3";
            } else {
                this.classification = this.classification + "5";
            }
        }
    }

    public String getImportanceTarget() {
        return this.byImportanceTarget;
    }

    public String getTargetClass() {
        return this.classification;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("\t");
        builder.append(this.classification);
        builder.append("\t");
        builder.append(this.byImportanceTarget);
        return builder.toString();
    }
}
