/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.beans;

import java.io.*;
import javax.xml.parsers.*;
import java.text.*;
import org.rhwlab.db.MySql;
import java.sql.ResultSet;
import java.sql.PreparedStatement;
import java.util.*;
import org.rhwlab.imaging.TIFF;
import java.awt.image.*;
import javax.imageio.*;
import javax.xml.xpath.XPath;
import org.primefaces.model.*;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.db.beans.Imaged;
import org.rhwlab.db.beans.Plasmid;
import org.rhwlab.db.beans.Strain;
import org.w3c.dom.Document;

/**
 *
 * @author gevirl
 */
public class SeriesMetaData extends Imaged {
    public SeriesMetaData(String id)throws Exception {
        super();
        super.fromXML(new File("/nfs/waterston/embryoDB/"+id+".xml"));
    }
    public SeriesMetaData() throws Exception {
        super();
 //       builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
 //       xpath = XPathFactory.newInstance().newXPath();
       
    }
    public SeriesMetaData(MySql db,String id) throws Exception {
        super(id);
    }    
    /*
    static SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    static SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd");
    
*/
    // organize a list of series by gene
    public static TreeMap<String,ArrayList<String>> byGene(MySql db, String[] seriesList) throws Exception {
        TreeMap<String,ArrayList<String>> ret = new TreeMap<String,ArrayList<String>>();
        
        for (String series : seriesList){
            SeriesMetaData metaData = new SeriesMetaData(db,series);
            if (metaData.getGene() == null){
                int ashdfuis=0;
            }
            ArrayList list = ret.get(metaData.getGene());
            if (list == null){
                list = new ArrayList<String>();
                ret.put(metaData.getGene(), list);
            }
            list.add(metaData.getId());
        }
        
        return ret;
    }
    // organize a list of series by construct
    public static TreeMap<String,ArrayList<String>> byConstruct(MySql db, String[] seriesList) throws Exception {
        TreeMap<String,ArrayList<String>> ret = new TreeMap<String,ArrayList<String>>();
        
        for (String series : seriesList){
            if (series.equals("20111129_unc-4_15_L1")){
                int asuihdfs=0;
            }
            SeriesMetaData metaData = new SeriesMetaData(db,series);
            String construct = metaData.getConstruct();
            
            ArrayList list = ret.get(construct);
            if (list == null){
                list = new ArrayList<String>();
                ret.put(construct, list);
            }
            list.add(metaData.getId());
        }
        
        return ret;
    }    
    
    // get a list of series for a given gene
    static public String[] seriesFromGene(MySql db, String gene) throws Exception {
        // first find the WBGene from the given gene 
        String sql = String.format("Select * from WBGenes where Alias=\'%s\'",gene);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            //now get all the series for the WBGene
            String wbGene = rs.getString("WBGene");
            sql = String.format("Select S.ID from Series S,WBGenes W where S.RedSig=W.Alias and W.WBGene=\'%s\' and "
                    + "EditedTimePoints > 0",wbGene);
            rs = db.execute(sql);
            ArrayList<String> seriesList = new ArrayList<String>();
            while (rs.next()){
                seriesList.add(rs.getString("ID"));
            }
            return seriesList.toArray(new String[0]);
        }
        return new String[0];
    }
    // return a list of all edited series in the db
    static public String[] allEdited(MySql db) throws Exception {
        TreeSet<String> set = new TreeSet(new Comparator<String>(){
            public int compare(String s1,String s2){
                return s1.compareToIgnoreCase(s2);
            }
        });

        String sql = "Select ID from Series where EditedTimePoints>0";
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            String id = rs.getString("ID");
            set.add(id);
        }
        
        return set.toArray(new String[0]);
    }    
    public static boolean isPromotor(MySql db, String seriesName)throws Exception {
        SeriesMetaData md = new SeriesMetaData(db,seriesName);
        if (md.getConstructType() == null){
            int sajidf=0;
        }
        return md.getConstructType().equals("Plasmid");

    }
    
    // for testing
    public static void main(String[] args){

        try {
            String id = "200900306cbrHIS72AF16_L1";
            SeriesMetaData md = new SeriesMetaData();
            MySql db = MySql.getMySql();
            md.fromXML(new File("/nfs/waterston/embryoDB/"+id+".xml") );
            DefaultStreamedContent content = new DefaultStreamedContent(md.getImageJPG(),"image/jpeg");
            ByteArrayInputStream stream = (ByteArrayInputStream)md.getImageJPG();
            FileOutputStream outStream = new FileOutputStream(new File(id+".jpg"));
            byte[] buf = new byte[1000];
            int n = stream.read(buf);
            while (n != -1){
                outStream.write(buf, 0, n);
                n = stream.read(buf);
            }
            int hh=0;
        } catch(Exception exc){
            exc.printStackTrace();
        }
    }
    /*
    String id;
    String person;
    String strain;
    String treatments;
    String redSig;
    Integer timePoints;
    Date seriesDate;
    String imageDir;
    String annotsDir;
    String editedBy;
    Integer editedTimePoints;
    Integer editedCells;
    String checkedBy;
    String status;
    String comments;
    String nucleiFile;
    String imageFile;
    String constructID;
    String constructType;
    String gene;
    Gene wbgene;
    Integer planes=null;
    InputStream imageJPG;
    
    DocumentBuilder builder;
    XPath xpath;
    */

    /*
    public void setConstruct(String con){
        this.constructID = con;
    }
    */ 
    // get the meta data from the mysql databse
    final public void fromSQL(MySql db,String id) throws Exception{
        this.id  = id;
        super.fromSQL();
 /*       
//        String sql = String.format("Select * from Series where ID=\'%s\'",id);
        String sql = String.format("Select I.*,S.ConstructType Construct from Imaged I left join Strain S on I.ID=S.StrainID where I.ID=\'%s\'",id);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            this.id = id;
            this.person = rs.getString("Person");
            this.strain = rs.getString("Strain");
            this.treatments = rs.getString("Treatments");
            this.redSig = rs.getString("RedSig").trim(); 
            if (this.redSig.equals("n/a")) {
                this.gene = "none";
            } else if (this.redSig.startsWith("no-rfp")){
                this.gene = "no_rfp_ctrl";
            } else {
                wbgene = new Gene();
                wbgene.fromMySqlByAlias(db, this.redSig);
                if (wbgene.getWBGene() == null){
                    this.gene = this.redSig;
                }
                else if (!wbgene.getCGC().equals("")){
                    this.gene = wbgene.getCGC();
                }else if (!wbgene.getSequenceName().equals("")) {
                    this.gene = wbgene.getSequenceName();
                } else {
                    this.gene = this.redSig;
                }
            }
            this.annotsDir = rs.getString("AnnotsDir").trim();
            this.imageDir = rs.getString("ImageDir").trim();
            this.editedBy = rs.getString("EditedBy");
            this.checkedBy = rs.getString("CheckedBy");
            this.status = rs.getString("Status");
            this.comments = rs.getString("Comments"); 
            this.timePoints = (Integer)rs.getObject("TimePoints");
            this.editedTimePoints = (Integer)rs.getObject("EditedTimePoints");
            this.editedCells = (Integer)rs.getObject("EditedCells");
            this.seriesDate = rs.getDate("SeriesDate"); 
            this.nucleiFile = rs.getString("NucleiFile");
            this.imageFile = rs.getString("ImageFile");
//            this.construct = rs.getString("Construct");
            Strain strainObj = Strain.fromMySql(this.strain);
            this.constructID = strainObj.getConstructID();
            this.constructType = strainObj.getConstructType();
            try {
            if (rs.getBlob("ImageJPG")!=null){
                this.imageJPG = rs.getBlob("ImageJPG").getBinaryStream();
                this.imageJPG.mark(100000);
            }
            } catch (Exception exc){}
        } 
*/        
/*
        sql = String.format("Select * from Gene G,WBGenes W where G.WBGene=W.WBGene and W.Alias=\'%s\' ", this.gene);
        rs = db.execute(sql);
        if (rs.next()){
            this.transcript = rs.getString("Canonical");
        } else {
            this.transcript=null;
        }
 * 
 */
    }
    // update the mysql database with this series meta data
    public void updateDB(MySql db)throws Exception {
        super.updateDB();
 /*       
        // is there already a record for this series
        String sql = String.format("Select * from Series where ID=\'%s\'",id);
        ResultSet rs = db.execute(sql);
        if (!rs.next()){
            // insert a new record
            sql = String.format("Insert into Series (ID) values (\'%s\')",id);
            db.execute(sql);
        }
        // update the record with available data
        if (this.person != null){
            sql = String.format("Update Series set Person=\'%s\' where ID=\'%s\'",this.person,id);
            db.execute(sql);
        }
        if (this.strain != null){
            sql = String.format("Update Series set Strain=\'%s\' where ID=\'%s\'",this.strain,id);
            db.execute(sql);
        } 
        if (this.treatments != null){
            sql = String.format("Update Series set Treatments=\'%s\' where ID=\'%s\'",this.treatments,id);
            db.execute(sql);
        } 
        if (this.redSig != null){
            sql = String.format("Update Series set RedSig=\'%s\' where ID=\'%s\'",this.redSig,id);
            db.execute(sql);
        }
        if (this.imageDir != null){
            sql = String.format("Update Series set ImageDir=\'%s\' where ID=\'%s\'",this.imageDir,id);
            db.execute(sql);
        }
        if (this.imageFile != null){
            sql = String.format("Update Series set ImageFile=\'%s\' where ID=\'%s\'",this.imageFile,id);
            db.execute(sql);
        }        
        if (this.annotsDir != null){
            sql = String.format("Update Series set AnnotsDir=\'%s\' where ID=\'%s\'",this.annotsDir,id);
            db.execute(sql);
        }
        if (this.nucleiFile != null){
            sql = String.format("Update Series set NucleiFile=\'%s\' where ID=\'%s\'",this.nucleiFile,id);
            db.execute(sql);
        }        
        if (this.editedBy != null){
            sql = String.format("Update Series set EditedBy=\'%s\' where ID=\'%s\'",this.editedBy,id);
            db.execute(sql);
        }
        if (this.checkedBy != null){
            sql = String.format("Update Series set CheckedBy=\'%s\' where ID=\'%s\'",this.checkedBy,id);
            db.execute(sql);
        }
        if (this.comments != null){
            // escape any single quotes in the comment
            String c = comments.replace("'","\"");
            sql = String.format("Update Series set Comments=\'%s\' where ID=\'%s\'",c,id);
            db.execute(sql);
        }
        if (this.status != null){
            sql = String.format("Update Series set Status=\'%s\' where ID=\'%s\'",this.status,id);
            db.execute(sql);
        }
        if (this.timePoints != null){
            sql = String.format("Update Series set TimePoints=%d where ID=\'%s\'",this.timePoints,id);
            db.execute(sql);
        }
        if (this.editedTimePoints != null){
            sql = String.format("Update Series set EditedTimePoints=%d where ID=\'%s\'",this.editedTimePoints,id);
            db.execute(sql);
        }
        if (this.editedCells != null){
            sql = String.format("Update Series set EditedCells=%d where ID=\'%s\'",this.editedCells,id);
            db.execute(sql);
        }
        if (this.seriesDate != null){
            sql = String.format("Update Series set SeriesDate=\'%s\' where ID=\'%s\'",getDate(),id);
            db.execute(sql);
        } 
        if (this.constructID != null){
            sql = String.format("Update Series set Construct=\'%s\' where ID=\'%s\'",this.constructID,id);
            db.execute(sql);
        } 
        if (imageJPG != null){
            sql = String.format("Update Series set ImageJPG=? where ID=\'%s\'",id);
            PreparedStatement ps = db.getStatement(sql);
            ps.setBinaryStream(1, imageJPG);         
            ps.execute();
        }
*/        
    }
  /*  
    public void fromXML(File xml) throws Exception  {
        
        Document doc = builder.parse(xml);
        
        // use xpath to extract the values
        id = xpath.evaluate("/experiment/series/@name",doc);
        person = xpath.evaluate("/experiment/person/@name", doc);
        strain = xpath.evaluate("/experiment/strain/@name", doc);
        treatments = xpath.evaluate("/experiment/treatments/@desc", doc);
        redSig = xpath.evaluate("/experiment/redsig/@value", doc);
        timePoints = null;
        try {
            timePoints = new Integer(xpath.evaluate("/experiment/timepts/@num", doc));
        } catch (Exception exc){}
        seriesDate = format.parse(xpath.evaluate("/experiment/date/@date", doc));
        imageDir = xpath.evaluate("/experiment/imageloc/@loc", doc).trim();
        annotsDir = xpath.evaluate("/experiment/annots/@loc", doc).trim();
        editedBy = xpath.evaluate("/experiment/editedby/@name", doc);
        editedTimePoints = null;
        try {
            editedTimePoints = new Integer(xpath.evaluate("/experiment/editedtimepts/@num", doc));
        }catch (Exception exc){}
        editedCells = null;    
        try {
            editedCells = new Integer(xpath.evaluate("/experiment/editedcells/@num", doc));
        } catch (Exception exc){}
        checkedBy = xpath.evaluate("/experiment/checkedby/@name", doc);
        status = xpath.evaluate("/experiment/status/@case", doc);
        comments = xpath.evaluate("/experiment/comments/@text", doc);
        
        // get the other xml file and parse it
        String[] tokens = annotsDir.split("/");
        String annotsXml = annotsDir.trim()+"/dats/"+tokens[tokens.length-1]+".xml";
        File xmlFile = new File(annotsXml);
        if (xmlFile.exists()){
        doc = builder.parse(xmlFile);
            nucleiFile = xpath.evaluate("/embryo/nuclei/@file",doc).trim();
            imageFile = xpath.evaluate("/embryo/image/@file",doc).trim();
        }
        
        // build the typical image JPG from a tiff
        this.getPlanes();
        if (this.planes==null) return;
        try {
        TIFF tiff = new TIFF(this.imageDir);
        if (this.editedTimePoints!=null){
            tiff.setTimeAndPlane(this.editedTimePoints/2, this.planes/2);
        } else {
            tiff.setTimeAndPlane(this.timePoints/2, this.planes/2);
        }
        BufferedImage image = tiff.getImage(true, true);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write(image, "jpg", os);
        imageJPG = new ByteArrayInputStream(os.toByteArray());  
        } catch (Exception exc){
            imageJPG = null;
        }
        
    }
    
    public String getDate(){
        if (seriesDate != null){
            return outFormat.format(seriesDate);
        }
        return null;
    }
    */
    public String getEditZip(){

        if (this.nucleiFile!=null){
            return this.nucleiFile;
        }
        String[] tokens = annotsDir.split("/");
        return annotsDir+"/dats/"+tokens[tokens.length-1]+"-edit.zip";        
    }
    /*
    public int getEditedTimePoints(){
        if (this.editedTimePoints != null)
            return this.editedTimePoints;
        else 
            return 0;
    }
    public int getEditedCells(){
        if (this.editedCells != null)
            return this.editedCells;
        else 
            return -1;
    }
   
    public int getTimePoints(){
        return this.timePoints;
    }
    *  */
 /*   
    public String getComments(){
        return this.comments;
    }
    public String getEditedBy(){
        return this.editedBy;
    }

    public String getStrain(){
        return strain;
    }
    public String getTreatments(){
        return treatments;
    }
    public String getRedSig(){
        return redSig;
    }
    public String getPerson() {
        return person;
    }
    public String getConstruct(){
        return constructID;
    }

    public String getImageDir(){
        return this.imageDir;
    }

    public String getGene(){
        return this.gene;
    }
    
    public Gene getWBGene(){
        return wbgene;
    }
    
    public String getTranscript(){
        return this.transcript;
    }
     * 
     */
    public String getId(){
        return id;
    }    
    public double getZPixelResolution() {
        return this.zPixRes;
    }
    /*
    public Integer getPlanes(){
        if (planes == null){
            File dir = new File(getLineageDir());
            File[] files = dir.listFiles(new FilenameFilter(){
                public boolean accept(File file,String name){
                    return name.contains("t001");
                }
            });
            if (files==null) return null;
            planes = new Integer(files.length);
        }
        return this.planes;
    }
    * */
    public String getLineageDir(){
        return getImageDir()+"/tif";
    }
    public String getExpressDir(){
        return getImageDir()+"/tifR";
    } 
    public InputStream getImageJPG() {
        return imageJPG;
    }
    public String getAnnotsDir(){
        return this.annotsDir;
    }

    public String getRedImageFile(int time,int plane){
        File file = new File(this.imageFile);
        String filename = file.getName();
        String basis = filename.substring(0, filename.length()-13);
        return String.format("%s/%s-t%03d-p%02d.tif", getExpressDir(),basis,time,plane);
    }
}
