/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.alignment;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.util.TreeMap;
/**
 *
 * @author gevirl
 */
public class CIGARHistogram implements Runnable {
    File bam;
    public CIGARHistogram(File bam){
        this.bam = bam;
    }
    @Override
    public void run() {
        int len = 53;
        long[] counts = new long[len];
        for (int i=0 ; i<len ; ++i){
            counts[i] = 0;
        }
        SamReader samReader = SamReaderFactory.makeDefault().open(bam);
        SAMRecordIterator iter = samReader.iterator();
        while (iter.hasNext()){
            SAMRecord record = iter.next(); 

            Integer nh = (Integer)record.getAttribute("NH");
            if (nh == 1){
                Cigar cigar = record.getCigar();
                int i = 0;
                for (CigarElement element : cigar.getCigarElements()){
                    CigarOperator op = element.getOperator();
                    if (op.toString().equals("M")){
                        i = i + element.getLength();
                    }
                }
                if (i==20){
                    String s = record.toString();
                    int ashfuisd=0;
                    
                }
                ++counts[i];
            }
        }
        long total = 0;
        for (int i=0 ; i< len ; ++i){
            total = total+ counts[i];
            System.out.printf("%d,%d\n", i,counts[i]);
        }
        System.out.printf("Total=%d\n", total);
    }
    static public void main(String[] args){
        CIGARHistogram hist = new CIGARHistogram(new File("/net/waterston/vol9/SingleCell/Aligned.out.bam"));
        hist.run();
    }
}
