/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;

/**
 *
 * @author gevirl
 */
public class GeneListPanel extends JPanel {
    public GeneListPanel(Set<String> geneSet)throws Exception {
        this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        DefaultListModel model = new DefaultListModel();
        for (String gene : geneSet){
/*            
            Gene geneBean = new Gene();
            geneBean.setWithExons(false);
            geneBean.fromMySqlBySequence(MySql.getMySql(), gene);
*/
            model.addElement(gene);
        }
        list = new JList(model);
        
        JButton display = new JButton("Display");
        display.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                notifyListeners();
            }
        });
        JScrollPane scroll = new JScrollPane(list);
        this.add(scroll);
        this.add(display);
    }
    public void addListener(ChangeListener listener){
        this.listeners.add(listener);
    }
    public List getSelected(){
        return list.getSelectedValuesList();
    }
    private void notifyListeners(){
        ChangeEvent event = new ChangeEvent(list.getSelectedValuesList());
        for (ChangeListener listener : listeners){
            listener.stateChanged(event);
        }
    }
    JList list;
    List<ChangeListener> listeners = new ArrayList<>();
}
