/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.io.File;

/**
 *
 * @author gevirl
 */
public class TimeWarpedDataSource extends DataSource implements Runnable {
    public TimeWarpedDataSource(){
        
    }
    public TimeWarpedDataSource(File dir,String[] exps)throws Exception {
        super(dir,exps);
    }
    public double[] getExperimentTimes(String experiment){
        double[] times =super.getExperimentTimes(experiment);
        double[] ret = new double[times.length];
        for (int i=0 ; i<ret.length ; ++i){
            ret[i] = kdeFile.warpTime(experiment, times[i]);
        }
        return ret;
    }
    public double[] getStageTimes(){
        return kdeFile.getStageTimes(17);
    }
    public void setPMatrixKDEFile(Object file)throws Exception {
        if (file instanceof String){
            kdeFile = new PMatrixKdeFile((String)file);
        } else if (file instanceof PMatrixKdeFile){
            kdeFile = (PMatrixKdeFile)file;
        }
        
    }
    public PMatrixKdeFile getKdeFile(){
        return kdeFile;
    }
    PMatrixKdeFile kdeFile;

    @Override
    public void run() {
        String[] exps = this.getExperiments();
        for (String exp : exps){
            double[] sampleTimes = super.getExperimentTimes(exp);
            
            double[] warpTimes = this.getExperimentTimes(exp);
            for (int i=0 ; i<sampleTimes.length ; ++i){
                System.out.printf("%s,%f,%f\n",exp,sampleTimes[i],warpTimes[i]);
            }
        }
    }
    

}
