/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
public class PMatrixKdeFile extends KdeFile {
    public PMatrixKdeFile(){
        
    }
    public PMatrixKdeFile(String file) throws Exception {
        super(file);
    }
    public PMatrixKdeFile(Element ele) throws Exception {
        super(ele);
    }
    public Double getValue(String variable,String type){
        Double ret = super.getValue(variable, type);
        if (ret == null && type.equals("Mode")) {
            ret = super.getValue(variable, "Value");
        }
        return ret;
    }
    
    public double[] getStageTimes(int N){
        if (stageTimes==null){
            double timeInc = this.getValue(incName, "Mode");
            stageTimes = new double[N];
            Double stageStart = this.getValue(startName,"Mode");
            if (stageStart != null){
                this.stagesStartTime = stageStart;
            }else {
                if (timeInc != 28.58){
                    this.stagesStartTime =  38.144;
                } else{
                    this.stagesStartTime =  28.58;
                }
            
            }            
            double time = this.stagesStartTime;
            for (int i=0 ; i<N ; ++i){
                stageTimes[i] = time;
                time = time + timeInc;
            }
        }
        return stageTimes;
    }
    public double warpTime(String experiment,double time){
        double growthRate = this.getValue(String.format("GrowthRate_%s",experiment),"Mode");
        double startTime = this.getValue(String.format("StartTime_%s",experiment), "Mode");
        return startTime + growthRate*time;
    }

    public static String incName = "TimeInc";
    public static String startName = "IncStartTime";    
    double[] stageTimes = null;
    double stagesStartTime;
}
