/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Set;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
// load features into the DCPM table from a data source
public class LoadFeatures {
    static public void main(String[] args)throws Exception {
        DataSource source = null;
        if (args.length==2){
            source = new DataSource(args[0],args[1]);
        } else {
            source = new DataSource(args[0]);
        }
        PreparedStatement state = MySql.getMySql().getStatement("Insert into DCPM (Feature,Experiment,Time,DCPM) values (?,?,?,?)");
        
        for (String experiment : source.getExperiments()){
            
            HashMap<String,double[]> dataMap = source.getExperimentSource(experiment).getDataMap();
            double[] times = source.getExperimentTimes(experiment);
            
            Set<String> features = source.getFeatures();
            
            for (String feature : features){
                System.out.printf("%s   %s\n", experiment,feature);
                
                // remove all the exisitng data for this experiment and feature
                String sql = String.format("Delete from DCPM where Experiment=\'%s\' and Feature=\'%s\'",experiment,feature);
                MySql.getMySql().execute(sql);
            
                double[] data = dataMap.get(feature);
                for (int i=0 ; i<data.length ; ++i){
                    state.setString(1, feature);
                    state.setString(2, experiment);
                    state.setInt(3, (int)times[i]);
                    state.setDouble(4, data[i]);
                    state.execute();
                }
            }
        }
    }
}
