/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
public class KDEDataSource {
    public KDEDataSource(Element kde) throws Exception {
        fileName = kde.getAttributeValue("file");
        nStages = Integer.parseInt(kde.getAttributeValue("stages"));
        if (fileName != null) readKDE(new File(fileName));
    }
    public void addFeatures(Element kde)throws Exception{
        fileName = kde.getAttributeValue("file");
        if (fileName != null) readKDE(new File(fileName));
    }
    public List<String> withinRadius(String centerGene,double radius,int shift,String type,boolean invert){
        ArrayList<String> ret = new ArrayList<String>();
        double r2 = radius*radius;
        double[] center = this.getData(centerGene, type);
        for (String gene : kdeMap.keySet()){
            double[] test = this.getData(gene, type);
            double sum = 0.0;
            for (int i=0 ; i<center.length;++i){
                int index = i + shift;
                if (index >=0 && index < test.length) {
                    double d = 0.0;
                    if (invert){
                        d = test[index]+center[i]-200.0;
                    }else {
                        d = test[index]-center[i];
                    }
                    sum = sum + d*d;
                }
            }
            if (sum < r2){
                ret.add(gene);
            }
        }
        return ret;
    }
    private void readKDE(File kdeFile) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(kdeFile));
        
        // read the header 
        heads = reader.readLine().split(",");
        int nTypes = heads.length-1;
        do {
            String line = reader.readLine();
            if (line == null) break;
            String[] tokens = line.split(",");
            
            // skip varaibles that are not per-stage variables
            if (tokens[0].contains("lambda")) continue;
            if (tokens[0].contains("tau")) continue;
            if (tokens[0].contains("MeanStage")) continue; 
            if (tokens[0].contains("VarianceStage ")) continue;  
            if (tokens[0].endsWith("Sigma")) continue; 
            if (tokens[0].endsWith("sigma2")) continue; 
            if (tokens[0].endsWith("B1")) continue;
            if (tokens[0].endsWith("B2")) continue;
            if (tokens[0].endsWith("mu")) continue; 
            if (tokens[0].endsWith("Initial")) continue;
            if (tokens[0].endsWith("Terminal")) continue;


           
            double[] data = new double[nTypes];
            for (int i=0 ; i<nTypes ; ++i){
                data[i] = Double.valueOf(tokens[i+1]);
            }
            kdeMap.put(tokens[0],data);
        } while (true);
        reader.close();
    } 
    // get the data for all stages given the feature and the data type
    public double[] getData(String feature,String dataType){
        int index = -1;
        for (int i=1 ; i<heads.length ; ++i){
            if (heads[i].equals(dataType)) {
                index = i-1;
                break;
            }
        }
        double [] ret;
        double[] data = kdeMap.get(feature);
        if (data == null){
            ret = new double[nStages];
            for (int i=0 ; i<this.nStages ; ++i){
                String key = String.format("%s_%02d",feature,i);
                data = kdeMap.get(key);
                if (data == null){
                    key = String.format("%s_%d",feature,i);
                    data = kdeMap.get(key);
                }
                try {
                ret[i] = data[index];
                } catch (Exception exc){
                    int ahsgdf=0;
                }
            }
        } else {
            ret = new double[1];
            ret[0] = data[index];
        }

        return ret;
    }

    public double[] getTimes(String experiment){
        return getData("Mean_"+experiment,"Mode");
    }
    public double[] getVariances(String experiment){
        return getData("Variance_"+experiment,"Mode");
    }
    public double[] getPrecisions(String experiment){
        return getData("Precision_"+experiment,"Mode");
    }    
    public int getStages(){
        return nStages;
    }
    // get all the features in the kde file 
    public Set<String> getAllFeatures(){
        return kdeMap.keySet();
    }
    public String  getFileName(){
        return fileName;
    }
    String fileName;
    int nStages;
    String[] heads;
    HashMap<String,double[]> kdeMap = new HashMap<String,double[]>(); // indexed by transcript name   
}
