/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.viewers;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.util.Comparator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.rhwlab.LMS.dataframe.FileDataFrame;

/**
 *
 * @author gevirl
 */
public class FileViewer extends JFrame {

    FileDataFrame df;
    TablePanel mainPanel;
    JCheckBoxMenuItem rowsItem = new JCheckBoxMenuItem("Rows", false);
    JCheckBoxMenuItem colsItem = new JCheckBoxMenuItem("Columns", true);
    JCheckBoxMenuItem logAxisItem = new JCheckBoxMenuItem("X Axis - Log(values)");

    public FileViewer(File dir) {
        JMenuBar bar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu openMenu = new JMenu("Open Dataframe");

        JMenuItem saveAs = new JMenuItem("Save As");
        fileMenu.add(openMenu);
        fileMenu.add(saveAs);

        saveAs.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    saveAs(dir);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });

        JMenuItem withHead = new JMenuItem("With Header Line");
        withHead.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    openWithHeader(dir);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        openMenu.add(withHead);

        JMenuItem noHead = new JMenuItem("No Header Line");
        noHead.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    openNoHeader(dir);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        openMenu.add(noHead);

        JMenuItem sepHead = new JMenuItem("Separate Header File");
        sepHead.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    openSeparateHeader(dir);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        openMenu.add(sepHead);

        bar.add(fileMenu);
        this.setJMenuBar(bar);

        JMenu editMenu = new JMenu("Edit");
        bar.add(editMenu);
        JMenuItem addCol = new JMenuItem("Add a Column");
        editMenu.add(addCol);
        addCol.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                addColumnFromFile(dir);
            }
        });

        JMenu selectionItem = new JMenu("Selection");
        selectionItem.add(rowsItem);
        rowsItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setRowColumnSelection();
            }
        });
        selectionItem.add(colsItem);
        colsItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setRowColumnSelection();
            }
        });
        bar.add(selectionItem);

        JMenu xform = new JMenu("Transforms");
        bar.add(xform);
        JMenuItem xpose = new JMenuItem("Transpose");
        xform.add(xpose);
        xpose.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                df.transpose();
            }
        });
        JMenu graphs = new JMenu("Graphs");

        JMenuItem kldiv = new JMenuItem("KL Divergence");
        graphs.add(kldiv);
        kldiv.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                klDivergence();
            }
        });

        JMenuItem kde = new JMenuItem("Kernel Density Estimator");
        graphs.add(kde);
        kde.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                kde();
            }
        });
        JMenuItem histGraph = new JMenuItem("Histogram");
        histGraph.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                histogram();
            }
        });

        JMenuItem cummGraph = new JMenuItem("Cummulative Dist");
        cummGraph.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cummulative();
            }
        });

        JMenuItem scatter = new JMenuItem("Scatter");

        scatter.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                scatter();
            }
        });

        graphs.add(histGraph);
        graphs.add(cummGraph);
        graphs.add(scatter);
        JMenu xAxis = new JMenu("X Axis");
        xAxis.add(this.logAxisItem);
        graphs.add(xAxis);
        
        bar.add(graphs);

        mainPanel = new TablePanel();
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add(new JScrollPane(mainPanel), BorderLayout.CENTER);
        this.setContentPane(content);
    }

    private void setRowColumnSelection() {
        if (colsItem.isSelected()) {
            mainPanel.setColumnSelectionAllowed(true);
        } else {
            mainPanel.setColumnSelectionAllowed(false);
        }
        if (rowsItem.isSelected()) {
            mainPanel.setRowSelectionAllowed(true);
        } else {
            mainPanel.setRowSelectionAllowed(false);
        }
    }

    private void scatter() {
        JFrame scatterFrame = new JFrame();
        scatterFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add(mainPanel.getScatterPanel("log10(TPM)", "log10(TPM)", false));
        scatterFrame.setContentPane(content);
        scatterFrame.pack();
        scatterFrame.setVisible(true);
    }

    private void cummulative() {
        String resp = JOptionPane.showInputDialog("Enter max TPM");
        if (resp != null) {
            JFrame cummFrame = new JFrame();
            cummFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
            JPanel content = new JPanel();
            content.setLayout(new BorderLayout());
            content.add(mainPanel.getCummDistPanel("maximum TPM", 10000, this.logAxisItem.isSelected(), Double.valueOf(resp)));
            cummFrame.setContentPane(content);
            cummFrame.pack();
            cummFrame.setVisible(true);
        }
    }

    private void klDivergence() {
        JFrame kldFrame = new JFrame();
        kldFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());

        Comparator cm = new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                s1 = s1.substring(2);
                s2 = s2.substring(2);
                return s1.compareTo(s2);
            }
        };

        content.add(mainPanel.getKLDivergence(cm, this.logAxisItem.isSelected()));
        kldFrame.setContentPane(content);
        kldFrame.pack();
        kldFrame.setVisible(true);
        int ioasdfhsd = 0;
    }

    private void kde() {
        JFrame kdeFrame = new JFrame();
        kdeFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        
        content.add(mainPanel.getKDE(this.logAxisItem.isSelected()));
        kdeFrame.setContentPane(content);
        kdeFrame.pack();
        kdeFrame.setVisible(true);
        int ioasdfhsd = 0;
    }

    private void histogram() {
        JFrame histoFrame = new JFrame();
        histoFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add(mainPanel.getHistogramPanel("Value", 200, this.logAxisItem.isSelected()));
        histoFrame.setContentPane(content);
        histoFrame.pack();
        histoFrame.setVisible(true);
    }

    private void openWithHeader(File dir) throws Exception {
        JFileChooser chooser = new JFileChooser(dir);
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            df = new FileDataFrame(chooser.getSelectedFile());
            mainPanel.setData(df);
        }
    }

    private void openNoHeader(File dir) throws Exception {
        JFileChooser chooser = new JFileChooser(dir);
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            df = new FileDataFrame(chooser.getSelectedFile(), false);
            mainPanel.setData(df);
        }
    }

    private void openSeparateHeader(File dir) throws Exception {
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setDialogTitle("Choose the data file");
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            File dataFile = chooser.getSelectedFile();
            chooser.setDialogTitle("Choose the header file");
            if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
                df = new FileDataFrame(dataFile, chooser.getSelectedFile());
                mainPanel.setData(df);
            }
        }

        TableCellRenderer rend = mainPanel.getDefaultRenderer(Double.class);
    }

    private void addColumnFromFile(File dir) {
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setDialogTitle("Choose the file with column(s) of data");
    }

    private void saveAs(File dir) throws Exception {
        JFileChooser chooser = new JFileChooser(dir);
        if (chooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
            PrintStream stream = new PrintStream(chooser.getSelectedFile());
            df.save(stream);
            stream.close();
        }
    }

    static public void main(String[] args) throws Exception {
        FileViewer viewer = new FileViewer(new File("/net/waterston/vol2/home/gevirl/"));
        viewer.pack();
        viewer.setSize(500, 500);
        viewer.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        viewer.setVisible(true);
    }
}
