/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import java.io.File;
import java.util.ArrayList;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.FileDataFrame;
import org.rhwlab.LMS.dataframe.investigator.Investigation;

/**
 *
 * @author gevirl
 */
public class UMAP {

    // run umap on a dataset from an Investigation
    // makes a new coordinates dataset in the dataframe
    // args[0] - investigation xml
    // args[1] - input dataframe 
    // args[2] - input dataset
    // args[3] - dimensions (2 or 3)
    static public void main(String[] args) throws Exception {
        int dim = Integer.valueOf(args[3]);
        Investigation inv = new Investigation(new File(args[0]));
        DataSet ds = inv.getDataSet(args[1], args[2]);
        String invName = inv.getFile().getName().replace(".xml", "");
        File dsFile = new File(inv.getFile().getParent(), String.format("%s%s%s.df", invName, args[1], args[2]));
        File umapFile = new File(inv.getFile().getParent(), String.format("%s%s%sUMAP.df", invName, args[1], args[2]));
        DataFrame df = ds.getDataFrame();
        String rowname = df.getColumnName(df.getRowNameColumn());
        ds.saveAs(dsFile, null);

        ArrayList<String> cmdList = new ArrayList<>();
        cmdList.add("/net/waterston/vol9/R/run_umap.sh");
        cmdList.add(dsFile.getPath());
        cmdList.add(rowname);
        cmdList.add(umapFile.getPath());
        ProcessBuilder pb = new ProcessBuilder(cmdList);
        //           pb.redirectError(errFile);
//            pb.redirectOutput(stdoutFile);
        Process p = pb.start();
        p.waitFor();
        
        // add the umap dataset to the datframe
        String[] heads = new String[dim];
        for (int i=0 ; i<heads.length ; ++i){
            heads[i] = String.format("%sUMAP%d",ds.toString(),i+1);
        }
        DataFrame umapFrame = new FileDataFrame(umapFile,heads);
        inv.mergeDataFrame("UMAP"+ds.toString(), umapFrame, df);
        inv.save();
        
        int oasdfsd = 0;
    }
}
