/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import com.jujutsu.tsne.barneshut.BHTSne;
import com.jujutsu.tsne.barneshut.BarnesHutTSne;
import com.jujutsu.tsne.barneshut.TSneConfiguration;
import com.jujutsu.utils.TSneUtils;
import java.util.TreeMap;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.investigator.BarnesHutParameterDialog;

/**
 *
 * @author gevirl
 */
public class BarnesHut implements Transform {
    static int iter = 1000;
    static double perplexity = 25.0;
    static String[] params={"PCAdims","Perplexity","Iterations"};
    @Override
    public DataSet xform(DataSet in,Normalization norm) {
        int asuidfuisdh=0;
        BarnesHutParameterDialog dialog = new BarnesHutParameterDialog(null,params);
        dialog.setVisible(true);
        if (!dialog.isAccepted()) return null;
        
        TreeMap<String,String> map = dialog.getValues();
        int pca = Integer.valueOf(map.get("PCAdims"));
        perplexity = Double.valueOf(map.get("Perplexity"));
        iter = Integer.valueOf(map.get("Iterations"));
        
        double[][] X = in.getAsDouble();
        norm.normalize(X);
        TSneConfiguration config = TSneUtils.buildConfig(X, 2, pca, perplexity, iter);
        BarnesHutTSne tsne = new BHTSne();
        double[][] Y = tsne.tsne(config); 
        
        
        // add the new columns to the df
        DataFrame df = in.getDataFrame();
        String[] heads = new String[2];
        heads[0] = "BHTsneX"+norm.toString()+in.toString();
        heads[1] = "BHTsneY"+norm.toString()+in.toString();
        int[] tsneCols = df.addColumns(Y, heads);
        
        // make a new dataset
        String[] attrKeys = new String[1];
        attrKeys[0] = "Coord";
        DataSet ret = new DataSet(this.toString()+in.toString()+norm.toString(),df,tsneCols,attrKeys); 
        ret.setAttribute(attrKeys[0],0,"X");
        ret.setAttribute(attrKeys[0],1,"Y");
        return ret;
    }
    
    @Override
    public String toString(){
        return "BHTsne";
    }
}
