/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class RowsInClusterPanel extends JPanel implements ChangeListener {

    JList geneList;
    //   JList attrList;
    String[] genesNames;
    DataSetAttributesPanel dsaPanel;
    InvestigatorFrame parent;
    ChartPanel chartPanel;
    JFrame plotframe;

    public RowsInClusterPanel(InvestigatorFrame parent, String[] geneNames, DataSetAttributesPanel dsaPanel) {
        this.dsaPanel = dsaPanel;
        this.parent = parent;
        this.genesNames = geneNames;
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

        geneList = new JList();
        geneList.addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (geneList.getSelectedValue() == null) {
                        return;
                    }
                    displayGeneFreeChart((String) geneList.getSelectedValue());
                }
            }
        });
        JScrollPane scroll = new JScrollPane(geneList);
        this.add(scroll);
        /*        
        attrList = new JList();
        attrList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        attrList.setBorder(new TitledBorder("X Axis"));
        this.add(Box.createVerticalStrut(20));
        
        this.add(Box.createVerticalStrut(20));
        this.add(attrList);
        this.add(Box.createVerticalStrut(20));
         */
        plotframe = new JFrame();
        plotframe.getContentPane().setLayout(new BorderLayout());
        plotframe.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    }

    public void setGeneNames(String[] genes) {
        this.genesNames = genes;
    }

    private void displayGeneFreeChart(String gene) {
        DataSet ds = parent.getSelectedDataSet();
        DataFrame df = ds.getDataFrame();
        
        Integer row = df.find(df.getHeaders().get(parent.getInvestigation().getRownameColumn()), gene);
        double[] v = ds.getRow(row);
        // determine how to stack the graph - what attributes are row and column

        Set<String> allAttrs = ds.getAttributes();
        List<String> colAttrs = dsaPanel.getSelectedAttributes();
        StringBuilder builder = new StringBuilder();
        builder.append(colAttrs.get(0));
        for (int i = 1; i < colAttrs.size(); ++i) {
            builder.append(",");
            builder.append(colAttrs.get(i));
        }

//        List<String> colAttrs = attrList.getSelectedValuesList();
        List<String> rowAttrs = new ArrayList<>();
        for (String attr : allAttrs) {
            boolean found = false;
            for (String colAttr : colAttrs) {
                if (attr.equals(colAttr)) {
                    found = true;
                    break;
                }
            }
            if (!found) {
                rowAttrs.add(attr);
            }
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int dsColumn = 0; dsColumn < ds.getColumns().length; ++dsColumn) {
            String rowKey = keyValue(ds, dsColumn, rowAttrs);
            String colKey = keyValue(ds, dsColumn, colAttrs);
            dataset.addValue(v[dsColumn], rowKey, colKey);
        }
        
        JFreeChart chart = ChartFactory.createStackedBarChart(gene, builder.toString(),ds.toString(), dataset, PlotOrientation.VERTICAL, false, true, true);
        chartPanel = new ChartPanel(chart);

        plotframe.getContentPane().removeAll();
        plotframe.add(chartPanel, BorderLayout.CENTER);
        plotframe.setVisible(true);
        plotframe.pack();
        plotframe.setSize(900, 600);
        plotframe.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

    }

    private String keyValue(DataSet ds, int dsColumn, List<String> attrs) {
        StringBuilder builder = new StringBuilder();
        for (String attr : attrs) {
            builder.append(ds.getAttribute(attr, dsColumn));
        }
        return builder.toString();
    }

    /*    
    private void displayGeneFreeChart(String gene){
        int n = dataCols.length/5 ;
        List<String> heads = df.getHeaders();
        Integer row = df.find(geneCol,gene);
        
        if (row != null){
            ArrayList<String> rowData = df.getRow(row);
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int offset = 0;
            for (int i=0 ; i<n ; ++i){
                for( int time=0 ; time<5 ; ++time){
                    int index = offset + time;
                    String name = FACSDataSet.parseName(heads.get(dataCols[index]));
                    String tissue = name.substring(0,name.indexOf("T"));
                    double v = Double.valueOf(rowData.get(dataCols[index]));
                    dataset.addValue(v,String.format("T%d",time),tissue);
                }
                offset = offset + 5;
            }
            JFreeChart chart = ChartFactory.createStackedBarChart
                        (gene,"Series", "TPM", dataset, PlotOrientation.VERTICAL,false,true,true);        
            chartPanel = new ChartPanel(chart);
            
            plotframe.getContentPane().removeAll();
            plotframe.add(chartPanel,BorderLayout.CENTER);
            plotframe.setVisible(true);
            plotframe.pack();	
            plotframe.setSize(900,600);        
            plotframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);             
        }        
    }    
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        int[] recs = (int[]) e.getSource();
        String[] values = new String[recs.length];
        for (int i = 0; i < recs.length; ++i) {
            values[i] = genesNames[recs[i]];
        }
        Arrays.sort(values, new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                String s1 = (String) o1;
                String s2 = (String) o2;
                return s1.compareToIgnoreCase(s2);
            }
        });
        DefaultListModel model = new DefaultListModel();
        for (String value : values) {
            model.addElement(value);
        }
        geneList.setModel(model);
        /*        
        DefaultListModel attrModel = new DefaultListModel();
        DataSet ds = parent.getSelectedDataSet();
        for (String attr : ds.getAttributes()){
            attrModel.addElement(attr);
        }
        this.attrList.setModel(attrModel);
         */
    }
}
