/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.tc33.jheatchart.HeatChart;

/**
 *
 * @author gevirl
 */
public class JHeatChartPanel extends JPanel {
    public JHeatChartPanel(double[][] z,int[][] clusters){
        this.z = z;
        this.clusters = clusters;
        heatChart = new HeatChart(z);
        heatChart.setShowXAxisValues(false);
        heatChart.setShowYAxisValues(false);
    }
    public void init(){
        heatChart.setLowValueColour(Color.blue);
        heatChart.setHighValueColour(Color.yellow); 
        if (xValues!=null) heatChart.setXValues(xValues);
        if (yValues !=null )heatChart.setYValues(yValues);
    }
  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2d = (Graphics2D) g;

    int width = this.getWidth();
    int height = this.getHeight();

    this.setOpaque(true);

    // clear the panel
    g2d.setColor(bg);
    g2d.fillRect(0, 0, width, height);
    
    BufferedImage imageTotal = (BufferedImage)heatChart.getChartImage();
    int bfHeight = imageTotal.getHeight();
    int bfWidth = imageTotal.getWidth();
    
    int delta = 88;
    int xDel = 25;
    BufferedImage labelImage = imageTotal.getSubimage(0, bfHeight-delta, bfWidth, delta);
   
    int labH = height-delta;
    BufferedImage yLabelImage = new BufferedImage(xDel,labH,imageTotal.getType());
    Graphics2D g2lab = (Graphics2D)yLabelImage.getGraphics();
    g2lab.setColor(Color.white);
    g2lab.fillRect(0, 0, xDel, labH);
    double total = 0;
    for (int cl=0 ; cl<clusters.length ; ++cl){
        total = total + clusters[cl].length;
    }
    int fh = g2lab.getFontMetrics().getHeight()+1;
    g2lab.setColor(Color.black);
    double f = 0.0;
    for (int cl=0 ; cl<clusters.length ; ++cl){
        int row = fh + (int)((double)labH*f);
        g2lab.drawString(Integer.toString(cl+1), 0, row);
        
        f = f + (double)clusters[cl].length/total;
    }    
    
//    AffineTransform xform = new AffineTransform();
//    xform.scale(1.0, .01);
//    g2d.drawImage(bufferedImage, xform, null);
    g2d.drawImage(imageTotal, xDel, 0, width , height - delta, 0, 0,bfWidth,bfHeight-delta,null);
    g2d.drawImage(labelImage, xDel, height - delta, width , height, 0, 0,bfWidth,delta,null);
    g2d.drawImage(yLabelImage, 0, 0, xDel, height - delta, 0, 0, xDel, labH, null);
    }

    public void setXValues(Object labels){
        xValues = (Object[])labels;
        heatChart.setShowXAxisValues(true);
    }
    public void setYValues(Object labels,int freq){
        yValues = (Object[])labels;
        heatChart.setShowYAxisValues(true);
        heatChart.setYAxisValuesFrequency(freq);
    }    
    private Color bg = Color.white;    
    double[][] z;
    int[][] clusters;
    Object[] xValues;
    Object[] yValues;
    HeatChart heatChart;
}
