/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.rhwlab.LMS.dataframe.DataFrame;

/**
 *
 * @author gevirl
 */
public class DataFrameBox extends Observable implements Observer {
    
    JComboBox box = new JComboBox();
    Investigation investigation;
    
    public DataFrameBox(){
        box.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                DataFrameBox.this.setChanged();
                DataFrameBox.this.notifyObservers(box.getSelectedItem());
            }
        });
    }
    
    public JComboBox getBox(){
        return box;
    }
    
    public DataFrame getSelected(){
        return (DataFrame)box.getSelectedItem();
    }


    @Override
    public void update(Observable o, Object arg) {
        Investigation inv = (Investigation)o;
        update(inv);
    }
    
    public void update(Investigation inv){
        this.investigation = inv;
        DefaultComboBoxModel m = new DefaultComboBoxModel();
        for (DataFrame df : inv.getDataFrames()){
            m.addElement(df);
        }
        box.setModel(m);
        box.setSelectedIndex(0);
        this.setChanged();
        this.notifyObservers(box.getSelectedItem());
    }
    public Investigation getInvestigation(){
        return investigation;
    }
}
