/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.FileDataFrame;
import org.rhwlab.LMS.dataframe.investigator.algorithm.Silhouette;
import org.rhwlab.heatmap.HeatMap;
import org.rhwlab.imaging.binarytree.Gradient;

/**
 *
 * @author gevirl
 */
public class ClusteringListPanel extends JPanel implements Observer, ActionListener {

    InvestigatorFrame parent;
    DataSetAttributesPanel dsaPanel;
//    JList list;
    JTree tree;
//    FileDataFrame df;
    JButton remove;
    JButton heatmap;
    JButton reorg;
    JButton silh;
    JButton csv;
    JFileChooser chooser;

    public ClusteringListPanel(InvestigatorFrame parent, DataSetAttributesPanel dsaPanel) {
        this.dsaPanel = dsaPanel;
        this.parent = parent;
        chooser = new JFileChooser();
        this.setLayout(new BorderLayout());

        JPanel south = new JPanel();
        GroupLayout southlayout = new GroupLayout(south);
        southlayout.setAutoCreateGaps(true);
        southlayout.setAutoCreateContainerGaps(true);
        remove = new JButton("Remove Selected");
        remove.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                removeSelected();
            }
        });
        heatmap = new JButton("Display HeatMap");
        heatmap.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                displayHeatmap();
            }
        });

        reorg = new JButton("Dispaly Cluster");
        reorg.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                parent.updateClusterList();
            }
        });

        silh = new JButton("Silhouette");
        silh.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                silhouette();
            }
        });

        csv = new JButton("Save CSV");
        csv.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (chooser.showSaveDialog(ClusteringListPanel.this) == JFileChooser.APPROVE_OPTION) {
                    try {
                        saveCSV(chooser.getSelectedFile());
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            }
        });

        southlayout.setHorizontalGroup(southlayout.createSequentialGroup().addComponent(remove).addComponent(heatmap).addComponent(reorg).addComponent(silh).addComponent(csv));
        southlayout.setVerticalGroup(southlayout.createParallelGroup().addComponent(remove).addComponent(heatmap).addComponent(reorg).addComponent(silh).addComponent(csv));
        this.add(south, BorderLayout.SOUTH);
        /*         
        list = new JList();
        list.addListSelectionListener(new ListSelectionListener(){
            @Override
            public void valueChanged(ListSelectionEvent e) 
                if (!e.getValueIsAdjusting()){
                    parent.updateClusterList();
                }
            }
        });
         */
        tree = new JTree();
        tree.setVisibleRowCount(10);
        tree.setRootVisible(false);
        /*        
        tree.addTreeSelectionListener(new TreeSelectionListener() {
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                parent.updateClusterList();

                int sdfuidshf = 0;

            }
        });
         */
        JScrollPane scroll = new JScrollPane(tree);
        this.add(scroll, BorderLayout.CENTER);
    }

    private void saveCSV(File file) throws Exception {

        Clustering cl = getSelectedClustering();
        cl.saveAsCSV(file, parent.getInvestigation().getDataRowNames());
    }

    // start the silhout calculation
    private void silhouette() {
        DataSet dataset = parent.getSelectedDataSet();
        Clustering cl = getSelectedClustering();
        cl.formSilhouette(dataset, this);

        /*        
        JFrame silhFrame = new JFrame();
        silhFrame.setTitle(getSelectedClustering().toString());
        SilhouettePanel panel = new SilhouettePanel(parent.getInvestigation(),dataset,cl,parent.getSelectedCluster()-1);
        silhFrame.getContentPane().add(panel);
        silhFrame.pack();
        silhFrame.setSize(500,900);
        silhFrame.setVisible(true);
        silhFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); 
         */
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Silhouette is done");
        update(parent.getInvestigation(), null);
    }

    /*
    private void reorder() {
        DataSet axes = dsPanel.getSelectedAxes();
        Clustering clust = this.getSelectedClustering();
        clust.reorganizeClusters(axes, new EuclideanDistance());
        parent.updateClusterList();
    }
     */
    private void removeSelected() {
              
        Clustering selCl = this.getSelectedClustering();
        DataFrame df = this.parent.getSelectedDataFrame();
        List<Clustering> clusterings = this.parent.getInvestigation().getClusterings(df);
        if (selCl != null){
            for (Clustering cl : clusterings){
                if (cl.toString().equals(selCl.toString())){
                    clusterings.remove(cl);
                    break;
                }
            }
        }
        
    }

    public void refresh() {
        this.parent.invalidate();
        this.parent.validate();
    }

    public Clustering getSelectedClustering() {
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getLastPathComponent();
            Object obj = node.getUserObject();
            if (obj instanceof Clustering) {
                return (Clustering) obj;
            } else {
                DefaultMutableTreeNode par = (DefaultMutableTreeNode) node.getParent();
                return (Clustering) par.getUserObject();
            }
        }
        return null;
    }

    public Silhouette getSelectedSilhouette() {
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getLastPathComponent();
            Object obj = node.getUserObject();
            if (obj instanceof Silhouette) {
                return (Silhouette) obj;
            }
        }
        return null;
    }

    private void displayHeatmap() {
        DataSet dataset = parent.getSelectedDataSet();
        int[][] clusters = getSelectedClustering().getClusters(false);
        double[][] x = dataset.getTransposedClustered(clusters);

        double pos = 0;
        TreeMap<Double, String> yLabels = new TreeMap<>();
        for (int c = 0; c < clusters.length; ++c) {
            int len = clusters[c].length;
            if (len > 0) {
                yLabels.put(pos + len / 2.0, Integer.toString(c + 1));
            }
            pos = pos + len;
        }

        double r = .5;
        double s = 2.5;
        TreeMap<Double, String> xLabels = new TreeMap<>();
        TreeMap<Double, String> seriesLabels = new TreeMap<>();
        for (int i = 0; i < 7; ++i) {
            String series = dataset.getAttribute("Series", 5 * i);
            seriesLabels.put(s, series);
            for (int j = 0; j < 5; ++j) {
                xLabels.put(r, String.format("T%d", j));
                ++r;

            }
            s = s + 5;
        }

        /*        
        String[] xLabels = new String[dataset.getColumns().length];
        Set<String> attrs = dataset.getAttributes();
        for (int i=0 ; i<xLabels.length ; ++i){
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String attr : attrs){
                if (!first) {
                    builder.append("_");
                    
                }
                builder.append(dataset.getAttribute(attr, i));
                first = false;
            }
            xLabels[i] = builder.toString();
        }
         */
        Color[] colors = {Color.BLUE, Color.GREEN, Color.YELLOW};
        Color[] gradient = Gradient.createMultiGradient(colors, 100);
        gradient[0] = Color.BLACK;
        HeatMap heatMap = new HeatMap(x, true, gradient);

        heatMap.setDrawXTicks(true);
        heatMap.setDrawYTicks(true);
        heatMap.setXLabels(xLabels);
        heatMap.setXLabels(seriesLabels);
        heatMap.setYLabels(yLabels);

        JFrame heatChartFrame = new SavableImageFrame();
        heatChartFrame.setTitle(getSelectedClustering().toString());
        heatChartFrame.getContentPane().add(heatMap);
        heatChartFrame.pack();
        heatChartFrame.setSize(500, 900);
        heatChartFrame.setVisible(true);
        heatChartFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        heatChartFrame.addWindowListener(new WindowAdapter() {
            public void windowClosed(WindowEvent e) {
                heatChartFrame.setVisible(false);
                heatChartFrame.remove(heatMap);
                heatChartFrame.dispose();
                Runtime r = Runtime.getRuntime();
                r.gc();
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        DataFrame df = (DataFrame) arg;
        Investigation inv = null;
        if (o instanceof DataFrameBox) {
            inv = this.parent.getInvestigation();
        }
        else if (o instanceof Investigation) {
            inv = (Investigation) o;
        }else {
            return;
        }
        update(inv,df);
    }
    public void update(Investigation inv,DataFrame df) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            List<Clustering> clList = inv.getClusterings(df);
            if (clList != null) {
                for (Clustering cl : inv.getClusterings(df)) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(cl);
                    root.add(node);
                    if (cl.getSilhouettes() != null) {
                        for (Silhouette s : cl.getSilhouettes()) {
                            DefaultMutableTreeNode silhNode = new DefaultMutableTreeNode(s);
                            node.add(silhNode);
                        }
                    }
                }

            }
            DefaultTreeModel model = new DefaultTreeModel(root);
            tree.setModel(model);        
    }

}
