/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.ml.distance.DistanceMeasure;

/**
 *
 * @author gevirl
 */
public class ClusterNode {
    double[] x;
    ClusterNode parent=null;
    ClusterNode left=null;
    ClusterNode right=null;
    int leaf;
    
    public ClusterNode(double[] x,int leaf){
        this.x = x;
        this.leaf = leaf;
    }
    
    public ClusterNode(ClusterNode left,ClusterNode right){
        this(combine(left,right),-1);
        left.parent = this;
        right.parent = this;
        this.left = left;
        this.right = right;
    }
    
    public List<ClusterNode> getLeaves(){
        List<ClusterNode> ret;
        if (leaf != -1) {
            ret = new ArrayList<>();
            ret.add(this);
        } else {
            ret = this.left.getLeaves();
            ret.addAll(this.right.getLeaves());
        }
        return ret;
    }
    static private double[] combine(ClusterNode left,ClusterNode right){
        double[] ret = new double[left.x.length];
        for (int i=0 ; i<ret.length ; ++i){
            ret[i] = (left.x[i] + right.x[i])/2.0;
        }
        return ret;
    }
    
    // find the two nodes that are closest based on the distance measure 
    static public int[] closestPair(List<ClusterNode> nodes,DistanceMeasure meas){
        int[] ret = new int[2];
        double minD = Double.MAX_VALUE;
        
        for (int i=0 ; i<nodes.size()-1 ; ++i){
            for (int j=i+1 ; j<nodes.size() ; ++j){
                double d = meas.compute(nodes.get(i).x,nodes.get(j).x);
                if (d < minD){
                    minD = d;
                    ret[0] = i;
                    ret[1] = j;
                }
            }
        }
        
        return ret;
    }
}
