/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;

/**
 *
 * @author gevirl
 */
public class FileDataFrame extends DataFrame {

    static String sep = ",|\t";
    File source;
    ArrayList<String> comments = new ArrayList<>();

    public FileDataFrame(File dataFile,File headerFile) throws Exception {
        this(dataFile,false);
        headers.clear();
        BufferedReader reader = new BufferedReader(new FileReader(headerFile));
        String line = reader.readLine();
        while(line != null){
            this.headers.add(line);
            line = reader.readLine();
        }
        reader.close();
        int iausdfuisdh=0;
    }
    public FileDataFrame(File dataFile,String[] heads)throws Exception {
        this(dataFile,false);
        this.headers.clear();
        for (String h : heads){
            this.headers.add(h);
        }
    }
    // dataframe has a header
    public FileDataFrame(File file) throws Exception {
        this(file,true);
    }
    public FileDataFrame(File file, boolean hasHeaders) throws Exception {
        super();
        source = file;
        BufferedReader reader = new BufferedReader(new FileReader(source));

        // read any comments
        String line = reader.readLine();
        while (line.charAt(0) == '#') {
            comments.add(line.substring(1));
            line = reader.readLine();
        }

        // process the headers
        if (hasHeaders) {
            for (String head : line.split(",|\t")) {
                this.headers.add(head);
            }
            line = reader.readLine();

        }

        while (line != null) {
            ArrayList<String> row = new ArrayList<>();
            for (String token : line.split(sep)) {
                row.add(token);
            }
            frame.add(row);
            line = reader.readLine();
        }
        reader.close();
        this.setName(file.getName());
        
        // make generic headers if none provided
        if (!hasHeaders){
            
            int nCol = this.getRow(0).size();
            for (int i=0 ; i<nCol ; ++i){
                headers.add(String.format("C%d",i));
            }
        
        }
    }

    public String[] getComments() {
        return comments.toArray(new String[0]);
    }

    public void addComment(String com) {
        comments.add(com);
    }

    public void removeComment(int i) {
        comments.remove(i);
    }

    public void save(File file) throws Exception {
        PrintStream stream = new PrintStream(file);

        for (String comment : comments) {
            stream.print('#');
            stream.println(comment);
        }
        super.save(stream);

        stream.close();
    }

    public static void main(String[] args) throws Exception {
        FileDataFrame df = new FileDataFrame(new File("/net/waterston/vol2/home/gevirl/MEME/cisbp/TF_Information/TF_Information_all_motifs.txt"));
        int uashdfuisdh = 0;
    }

}
