/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.io.File;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class FACSSamples {

    static String[] allSamples;

    public static String parseName(String name) {
        String s = name.replace("RiboZeroBitSeq1.16.0_", "");
        return s.substring(0, s.indexOf('_'));
    }

    public static String tissueName(String name) {
        String s = parseName(name);
        int index = s.indexOf("rep");
        if (index == -1) {
            index = s.indexOf("T");
        }
        String ret = s.substring(0, index);
        if (ret.startsWith("nhr")) {
            ret = ret.replace("end1", "");
        }
        return ret;
    }

    public static String timeString(String name) {
        int index = name.indexOf("T");
        return name.substring(index, index + 2);
    }

    static public String[] getAllSamples() {
        allSamples = new String[5 * t0.length];
        int j = 0;
        for (int i = 0; i < t0.length; ++i) {
            allSamples[j++] = t0[i];
            allSamples[j++] = t1[i];
            allSamples[j++] = t2[i];
            allSamples[j++] = t3[i];
            allSamples[j++] = t4[i];
        }
        return allSamples;
    }

    static public void main(String[] args) throws Exception {
        int c25 = 0;
        int c100 = 0;
        FileDataFrame df = new FileDataFrame(new File("/net/waterston/vol2/home/gevirl/FACS/FACS_AllGenes_TPM.csv"));
        TreeMap<String,List<Integer>> map = df.indexColumn("SequenceName");
        String listStr = "F31A3.1, F40G9.4, B0523.1, C49D10.6, F48G7.3, C01G5.2, F37C12.16, DC2.6, C41G6.9, D1065.4, K03D7.4, T09F5.8, T06A1.2, C03G6.18, C13D9.2, C50C10.8, K10G4.9, K10G4.2, H24D24.2, Y38H6C.2, W06G6.13, K04F1.2, T05B4.5, T01C4.5, T27C5.2, Y102A5C.24, F43A11.3, F47B8.11, T13F3.1, F49C5.6, K10C9.8, F46F11.3, T17A3.8, AH10.3, B0391.3, C06B8.11, C06C6.1, C06C6.6, C08F11.2, C11G10.2, C14B1.7, C18B12.5, C31C9.4, C32H11.7, C34C6.2, C45G3.4, C54E10.1, C55A1.9, C55A1.14, C55A1.15, C56G7.2, CE7X_3.1, F10A3.16, F11A5.6, F12F6.2, F14H3.9, F15A4.8, F15G9.3, F16H6.5, F16H6.6, F17C11.1, F20E11.5, F21F12.1, F28B1.3, F28B1.4, F28B1.5, F35E8.4, F49E11.8, F52D10.6, F53B2.1, F56H11.6, H12I19.8, H36L18.2, K02E11.9, K03D7.8, K03D7.9, K03H4.2, K06B4.3, K08E4.4, K09G1.3, M01E5.1, M162.1, R09E10.4, T03E6.2, T07C5.4, T07G12.8, T08D2.2, T08G3.7, T08G5.8, T08G5.9, T10C6.2, T11F9.13, T12A7.7, T20F10.5, T21H8.5, T23F1.3, T27C5.7, T27E9.8, T28F4.6, VC27A7L.1, W05B2.7, W05H5.2, Y9C2UA.2, Y32B12A.4, Y37H2C.1, Y38E10A.10, Y38H6C.5, Y38H6C.10, Y39B6A.18, Y39B6A.32, Y40H7A.9, Y43F8C.18, Y47D3A.5, Y47H9C.15, Y48A6B.10, Y48E1C.3, Y51H4A.2, Y51H4A.21, Y53C10A.2, Y53C10A.3, Y57G11C.18, Y70C5C.3, Y102A5C.23, Y105C5A.22, Y105E8A.24, Y105E8A.29, Y106G6G.6, Y111B2A.9, Y116A8C.1, Y116F11B.11, ZC101.1, ZC412.4, ZC518.4, ZK218.8, ZK550.1, ZK1010.6, T09F5.12, B0047.2, B0222.10, B0238.13, B0432.6, B0554.3, C01B7.3, C02G6.1, C03A7.12, C04E6.3, C04E7.4, C04E12.6, C04E12.10, C04E12.11, C04E12.12, C06G1.5, C08E3.2, C08E3.11, C08G5.1, C08G5.3, C09H5.1, C13A2.2, C13A2.11, C14C6.7, C14C6.12, C14E2.2, C16C4.16, C16D9.7, C17B7.2, C18A11.6, C18C4.5, C18H7.5, C24B9.2, C25H3.8, C29F5.5, C29F9.10, C29F9.11, C29G2.1, C29G2.2, C30G12.3, C31B8.2, C32B5.3, C33E10.6, C36C5.9, C37C3.3, C38C3.7, C38C3.8, C39B5.8, C39D10.9, C40A11.10, C41D7.1, C45H4.6, C46E10.9, C46H3.3, C47C12.4, C49G7.1, C49G7.6, C50E3.2, C50E3.8, C50H11.3, C50H11.5, C50H11.17, C52D10.1, C55H1.1, CD4.5, D1065.3, D2007.3, E03H12.9, EGAP798.1, F07C4.9, F09C11.1, F10D2.12, F10E7.3, F12E12.3, F13A2.6, F13H6.4, F15E11.5, F15E11.10, F16B4.3, F16G10.15, F19F10.6, F19F10.8, F21E9.6, F21F8.2, F21F8.6, F22D3.5, F22H10.4, F22H10.5, F26D11.4, F28A10.2, F28A10.9, F28A10.10, F29A7.7, F29G9.7, F31A9.2, F31E8.1, F31F7.3, F35F10.4, F35F10.10, F35F11.3, F35H12.7, F36A4.11, F36F12.4, F36H5.11, F36H9.8, F38E1.11, F43E2.9, F44E2.2, F45D11.1, F45D11.8, F46F5.4, F47C10.2, F47F6.4, F47G3.2, F48A11.2, F49F1.8, F52C6.5, F53C3.5, F53E10.3, F55A3.7, F55A12.1, F56A4.6, F56A4.11, F56A11.7, F56B3.3, F56H1.2, F58F6.3, F59A3.5, F59A7.8, F59D6.6, F59E11.8, F59H6.2, F59H6.3, F59H6.4, F59H6.6, H08J11.2, H10D18.6, H12I13.2, H12I13.5, H17B01.3, K01A2.3, K02E7.6, K03H9.1, K04A8.2, K04A8.3, K04A8.10, K04F1.1, K04F1.11, K06C4.7, K06H6.6, K07B1.8, K07E8.1, K08D9.5, K08D10.5, K09C6.1, K09C6.6, K09D9.11, K09D9.12, K09E3.4, K09H11.5, K12B6.6, K12B6.8, K12D9.12, M02F4.3, R06B10.1, R07C3.14, R07C12.2, R08E3.2, R08F11.6, R09B5.1, R11G11.3, R12C12.8, R13A1.7, R13F6.2, R52.3, R106.1, R151.4, T01C8.4, T04B8.2, T05B4.4, T07A9.1, T07D1.5, T07D3.1, T07D3.3, T07D3.5, T07D3.6, T07H6.4, T08B2.3, T08H10.4, T10B5.2, T15B7.10, T15B7.17, T17A3.9, T19H12.8, T20C7.2, T20D4.4, T20D4.8, T20D4.9, T20D4.13, T20D4.17, T20F7.5, T20H12.1, T22B11.3, T22D1.2, T22D1.6, T23B3.3, T23F4.1, T24A6.2, T28A11.5, T28A11.6, T28B4.2, T28C12.5, VC5.1, W02D7.9, W02H5.4, W02H5.5, W03A5.4, W03D2.6, W03F9.3, W03G1.8, W04B5.1, W05F2.5, W05H9.3, W06H8.4, W07B8.3, W08F4.11, W10D9.2, W10G11.7, W10G11.17, Y9C9A.15, Y9C9A.17, Y9D1A.2, Y19D10A.10, Y19D10B.1, Y19D10B.4, Y19D10B.5, Y22D7AR.12, Y24D9A.5, Y32G9A.10, Y32G9A.11, Y38C9A.1, Y39F10A.2, Y39H10A.4, Y39H10A.5, Y40A1A.1, Y40B10A.4, Y40C7B.3, Y40C7B.5, Y45G12C.11, Y46H3C.4, Y46H3C.6, Y47D7A.10, Y47G6A.29, Y48G1BM.6, Y50D4A.3, Y50D4B.3, Y50D4B.7, Y50D4C.2, Y50D7A.11, Y50F7A.2, Y53G8B.3, Y54G2A.9, Y55B1AL.1, Y55F3BR.7, Y59E1B.1, Y59E1B.2, Y64H9A.1, Y71G12B.7, Y73B3A.3, Y73B3A.9, Y73B3A.10, Y73B3A.12, Y77E11A.3, Y108F1.4, Y110A2AM.1, Y110A2AM.4, ZC132.2, ZC132.4, ZC132.8, ZC178.1, ZC190.9, ZC317.1, ZC404.7, ZC411.1, ZC487.3, ZC513.1, ZC513.10, ZK6.1, ZK112.3, ZK353.5, ZK488.1, ZK546.3, ZK546.7, ZK697.3, ZK783.3, ZK783.5, ZK994.1, ZK1055.5, ZK1193.3, ZK1193.4, Y7A9C.8, C47G2.8, F57B1.8, R09E10.10, Y55B1BR.5, F36H2.5, F40H6.6, F46F11.11, Y54G2A.42, Y59E9AR.10, D2024.10, K10C9.9, Y32G9A.13, W02H5.10, F37B4.14, K09H11.10, F36D4.7, C36B7.8, C24H12.12, T13F3.9, T28D9.12, F22G12.8, T20D4.20, F47E1.5, C54D10.12, F11D11.11, Y6G8.9, K02E11.11, C06G1.6, cTel3X.1, F35C8.9, E02A10.5, C03C10.9, Y39F10C.2, Y50D7A.12, H06H21.36, W02H5.12, Y10G11A.90, F37H8.7, C54E10.8, C56E6.9, F19G12.10, T04A6.5, C54F6.16, F44E7.12, B0507.15, F47E1.17, R13D11.11, R106.5, Y80D4G.1, F44E2.11, F57A8.10, M151.9, Y13C8A.4, W02G9.10, Y80D3A.16, C38D9.13, W03D2.13, K08D10.18";
        String[] pseudo = listStr.split(",");
        for (int i=0 ; i<pseudo.length ; ++i){
            String gene = pseudo[i].trim();
            List<Integer> rows = map.get(gene);
            int row = rows.get(0);
            List<String> vals = df.getRow(row);
            double max = 0.0;
            for (int r=2;r<vals.size();++r){
                double v = Double.valueOf(vals.get(r));
                if (v > max){
                    max = v;
                }
            }
            if (max > 25){
                ++c25;
            }
            if (max > 100 ){
                ++c100;
            }
            System.out.printf("%s %.3f\n", gene,max);
            
            
            int sdfios=0;
        }
        System.out.printf("%d  %d\n",c25,c100);

    }
    static String[] t0 = {
        "RiboZeroBitSeq1.16.0_ceh32rep2T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_ceh32repT0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1repT0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1repT0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep2T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep3T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep4T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1repT0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4repT0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37repT0_1_2_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep3T0_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep4T0_1_1_Merged1"
    };
    static String[] t1 = {
        "RiboZeroBitSeq1.16.0_ceh32rep2T1_1_1_Merged2",
        "RiboZeroBitSeq1.16.0_ceh32repT1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1repT1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1repT1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep2T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep3T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep4T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1repT1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4repT1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37repT1_1_2_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep3T1_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep4T1_1_1_Merged1"
    };
    static String[] t2 = {
        "RiboZeroBitSeq1.16.0_ceh32rep2T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_ceh32repT2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1repT2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1repT2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep2T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep3T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep4T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1repT2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4repT2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37repT2_1_2_Merged3",
        "RiboZeroBitSeq1.16.0_tbx37rep3T2_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep4T2_1_1_Merged1"
    };
    static String[] t3 = {
        "RiboZeroBitSeq1.16.0_ceh32rep2T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_ceh32repT3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1repT3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1repT3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep2T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep3T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep4T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1repT3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4repT3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37repT3_1_2_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep3T3_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep4T3_1_1_Merged1"
    };
    static String[] t4 = {
        "RiboZeroBitSeq1.16.0_ceh32rep2T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_ceh32repT4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1repT4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_cnd1T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1repT4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_end1T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep2T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep3T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_hlh1rep4T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1repT4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_nhr25end1T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4repT4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_pha4T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37repT4_1_2_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep3T4_1_1_Merged1",
        "RiboZeroBitSeq1.16.0_tbx37rep4T4_1_1_Merged1"
    };
}
