/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.JFrame;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.ColorBrewer;

/**
 *
 * @author gevirl
 */
public class DensityPeakCluster {
    DataFrame df;
    Record[] recs;
    
    public DensityPeakCluster(DataFrame df){
        this.df = df;
    }
    
    public String[] getClusterLabels(){
        String[] ret = new String[recs.length];
        for (int i=0 ; i<recs.length ; ++i){
            ret[i] = recs[i].label;
        }
        return ret;
    }
    // minimum distance to an observation of higher density
    static public void calcDelta(DistanceMatrix distances,Record[] recs){
        for (int i=0 ; i<recs.length ; ++i){
            Record irec = recs[i];
            boolean noMin = true;
            double minDist = Double.MAX_VALUE;
            double maxDist = Double.MIN_VALUE;
            int near = -1;
            for (int j=0 ; j<recs.length ; ++j){
                Record jrec = recs[j];
                double dist = distances.getDistance(i, j);
                if (dist > maxDist){
                    maxDist = dist;
                }
                if (irec.rho < jrec.rho){
                    if (minDist > dist){
                        minDist = dist;
                        near = j;
                        noMin = false;
                    }
                }
            }
            if (noMin){
                irec.delta = maxDist;
                irec.nearest = -1;
            } else {
                irec.delta = minDist;
                irec.nearest = near;
            }
        }
        
    }
    static public double findCutoff(DistanceMatrix distances){
        double minRho = 0.01 * distances.size();
        double maxRho = 0.02 * distances.size();
        double min = distances.getMin();
        double max = distances.getMax();
        double cutoff=(min+max)/2.0;
        
        while (true){
            Record[] rs = calcRho(distances, cutoff);
            double sum = 0;
            for (Record r : rs){
                sum = sum + r.rho;
            }
            double avgRho = (double)sum/(double)rs.length;
            if (minRho <= avgRho && avgRho <= maxRho) break;
            
            if (avgRho < minRho ){
                min = cutoff;
            } else {
                max = cutoff;
            }
            cutoff=(min+max)/2.0;
        }
        return cutoff;
    }
    
    // the number of observations within the cutoff distance for each observation
    static public Record[] calcRho(DistanceMatrix distances,double cutoff){
        return calcRhoGaussian(distances,cutoff);
/*        
        Record[] ret = new Record[distances.size()];
        for (int i=0 ; i<ret.length ; ++i){
            int count = -1;
            for (int j=0 ; j<ret.length ; ++j){
                if ( distances.getDistance(i, j) < cutoff){
                    ++count;
                }
            }
             ret[i] = new Record(count);
        }
        return ret;
*/        
    }
    

    static public Record[] calcRhoGaussian(DistanceMatrix distances,double cutoff){    
        Record[] ret = new Record[distances.size()];    
        for (int i=0 ; i<ret.length ; ++i){
            double sum = 0.0;
            for (int j=0 ; j<ret.length ; ++j){
                double d = distances.getDistance(i, j);
                double dc = d/cutoff;
                double e = -dc*dc;
                sum = sum + Math.exp(e);
            }
            ret[i] = new Record(sum);
        }        
        return ret;
    }
    public void calcRhoDelta(double[][] x,DistanceMeasure measure){
        DistanceMatrix m = new DistanceMatrixImpl(x,measure);
        double cutoff = findCutoff(m);
        System.out.printf("Cutoff = %s\n",cutoff);
        recs = calcRho(m, cutoff);
        calcDelta(m, recs);   
    }

    static public Record[] cluster(double cutoff,double deltaThresh,double rhoThresh,double[][] x,DistanceMeasure measure){
        DistanceMatrix m = new DistanceMatrixImpl(x,measure);
        Record[] recs = calcRho(m, cutoff);
        calcDelta(m, recs); 
      
        // find the cluster centers and label them
        int l = 1;
        for (Record rec : recs){
            double rho = rec.rho;
            double delta = rec.delta;
            if (rho >= rhoThresh){
                if (delta >= deltaThresh){
                    rec.label = Integer.toString(l);
                    ++l;
                }
            } 

        }

        for (int i=0 ; i<recs.length ; ++i){
            setRecordCluster(i,recs);
        }
        return recs;
    }
    
    static private String setRecordCluster(int r,Record[] recs){
        if (recs[r].label == null){
            int parent = recs[r].nearest;
            if (parent == -1){
                int ashdfisd=0;
            }
            recs[r].label = setRecordCluster(parent,recs);
        }
        return recs[r].label;
    }
    

    public void decisionPlot(){
        ColorBrewer[] brewers = ColorBrewer.getDivergingColorPalettes(true); 
        brewers = ColorBrewer.getQualitativeColorPalettes(true);
        Color[] colors = brewers[0].getColorPalette(1);
        Plot2DPanel plot = new Plot2DPanel();
        double[][] XY = new double[recs.length][];
        for (int i=0 ; i<recs.length ; ++i){
                Record rec = recs[i];
                XY[i] = new double[2];
                XY[i][0] = Double.valueOf(rec.rho);
                XY[i][1] = Double.valueOf(rec.delta);
        }   
            plot.addScatterPlot("delta", colors[0], XY);
        plot.plotCanvas.setNotable(true);
        plot.plotCanvas.setNoteCoords(true);
        plot.addLegend("SOUTH");
        FrameView plotframe = new FrameView(plot);
        plotframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        plotframe.setVisible(true);         
    }    
    

}
